/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.outlookmessageparser.model;

import org.simplejavamail.outlookmessageparser.model.MimeType;
import org.simplejavamail.outlookmessageparser.model.OutlookAttachment;
import org.simplejavamail.outlookmessageparser.model.OutlookMessageProperty;

public class OutlookFileAttachment
implements OutlookAttachment {
    private String filename;
    private String longFilename;
    private String mimeTag;
    private String contentId;
    private String extension;
    private byte[] data;
    private long size = -1L;

    public void setProperty(OutlookMessageProperty msgProp) {
        String name = msgProp.getClazz();
        Object value = msgProp.getData();
        if (name != null && value != null) {
            switch (name) {
                case "3701": {
                    this.setSize(msgProp.getSize());
                    this.setData((byte[])value);
                    break;
                }
                case "3704": {
                    this.setFilename((String)value);
                    break;
                }
                case "3707": {
                    this.setLongFilename((String)value);
                    break;
                }
                case "370e": {
                    this.setMimeTag((String)value);
                    break;
                }
                case "3703": {
                    this.setExtension((String)value);
                    break;
                }
                case "3712": {
                    this.setContentId((String)value);
                    break;
                }
            }
        }
    }

    public void checkSmimeFilename() {
        if (this.filename == null && this.mimeTag != null && this.mimeTag.contains("multipart/signed") && (!this.mimeTag.contains("protocol") || this.mimeTag.contains("protocol=\"application/pkcs7-signature\""))) {
            this.filename = "smime.p7s";
        }
    }

    public void checkMimeTag() {
        if (this.mimeTag == null || this.mimeTag.length() == 0) {
            if (this.filename != null && this.filename.length() > 0) {
                this.mimeTag = MimeType.getContentType(this.filename);
            } else if (this.longFilename != null && this.longFilename.length() > 0) {
                this.mimeTag = MimeType.getContentType(this.longFilename);
            }
        }
    }

    public String toString() {
        return this.longFilename != null ? this.longFilename : this.filename;
    }

    public String getContentId() {
        return this.contentId;
    }

    void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getExtension() {
        return this.extension;
    }

    void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFilename() {
        return this.filename;
    }

    void setFilename(String filename) {
        this.filename = filename;
    }

    public String getLongFilename() {
        return this.longFilename;
    }

    void setLongFilename(String longFilename) {
        this.longFilename = longFilename;
    }

    public String getMimeTag() {
        return this.mimeTag;
    }

    void setMimeTag(String mimeTag) {
        this.mimeTag = mimeTag;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    void setData(byte[] data) {
        this.data = data;
    }

    public long getSize() {
        return this.size;
    }

    void setSize(long size) {
        this.size = size;
    }
}

