/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.boreum;

import de.governikus.updater.Logger;
import de.governikus.updater.Utils;
import de.governikus.updater.boreum.BoreumStarter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class WebBoreumStarter {
    protected static final String LOCK_FILE = "WebBoreum.lock";
    protected final File lockfile = new File(new File(System.getProperty("java.io.tmpdir")), "WebBoreum.lock");

    private boolean isLocked() {
        return Utils.isLocked((File)this.lockfile);
    }

    private void lock() {
        try {
            Utils.lock((File)this.lockfile);
        }
        catch (IOException e) {
            Logger.error((String)"", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.unlock()));
    }

    private void unlock() {
        Utils.unlock((File)this.lockfile);
    }

    private void storeArguments(String[] args) {
        this.processParameters(args);
    }

    private String[] processParameters(String[] args) {
        if (args == null || args.length == 0) {
            Logger.error((String)("args = " + args));
            Logger.error((String)"Filename as args expected.");
            return null;
        }
        Logger.info((String)("args size : " + args.length));
        Logger.info((String)("Downloaded file: " + args[0]));
        Preferences pref = Preferences.userRoot().node("de").node("governikus").node("webboreum").node("setupfile");
        try {
            pref.clear();
            pref.flush();
        }
        catch (BackingStoreException ex) {
            Logger.error((Throwable)ex);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            Logger.info((String)("setup file: " + arg));
            arguments.add(arg);
        }
        long time = System.currentTimeMillis();
        int i = 0;
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            File file = new File(arg);
            if (this.isLocalFile(file)) {
                Logger.info((String)("is local? true : " + arg));
                pref.put(time + "_" + i++, arg);
                try {
                    pref.flush();
                }
                catch (Exception e) {
                    Logger.error((String)e.getMessage());
                }
                Logger.info((String)("path: " + arg));
                it.remove();
                continue;
            }
            Logger.info((String)("URL in setup file is not local: " + arg));
            try (FileInputStream is = new FileInputStream(file);){
                InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                try (BufferedReader br = new BufferedReader(isr);){
                    String url = br.readLine();
                    pref.put(time + "_" + i++, url);
                    pref.flush();
                    Logger.info((String)("Preferences url: " + url));
                    it.remove();
                }
            }
            catch (Exception e) {
                Logger.error((String)("Failed read file from URL: " + (String)arguments.get(0)), (Throwable)e);
            }
        }
        return arguments.toArray(new String[0]);
    }

    private boolean isLocalFile(File file) {
        Properties props = new Properties();
        try {
            try (FileInputStream is = new FileInputStream(file);){
                props.load(is);
            }
            if (props.isEmpty()) {
                return false;
            }
            if (props.getProperty("signer.process", null) != null) {
                return true;
            }
        }
        catch (IOException ex) {
            Logger.error((String)("File is not local: " + ex.getMessage()));
        }
        return false;
    }

    private void startOfflineApp(String[] args) {
        try {
            Class<?> c = Class.forName("de.bos_bremen.ecard.client.WebSigner");
            Method main = c.getMethod("main", String[].class);
            main.invoke(c, new Object[]{args});
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            File tempDir = new File(System.getProperty("java.io.tmpdir"), "Governikus KG");
            tempDir = new File(tempDir, "GovernikusBoreumWebEdition");
            BoreumStarter.delete(tempDir);
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            System.setOut(new PrintStream(new File(tempDir, System.currentTimeMillis() + ".out.log")));
            System.setErr(new PrintStream(new File(tempDir, System.currentTimeMillis() + ".err.log")));
            Logger.info((String)("Logfiles in: " + tempDir.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
        }
        if (args == null || args.length == 0) {
            Logger.error((String)"args as downloaded local file setup.gov-ws expected.");
        } else {
            Logger.info((String)("args.length = " + args.length));
            Logger.info((String)("Downloaded setup.gov-ws: " + args[0]));
        }
        WebBoreumStarter s = new WebBoreumStarter();
        boolean wasLocked = s.isLocked();
        Logger.info((String)("was locked: " + wasLocked));
        if (wasLocked) {
            s.storeArguments(args);
            return;
        }
        Logger.info((String)"lock ... ");
        s.lock();
        s.startOfflineApp(s.processParameters(args));
    }
}

