/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.boreum;

import de.governikus.updater.Logger;
import de.governikus.updater.Project;
import de.governikus.updater.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BoreumStarter {
    protected static final String LOCK_FILE = "BOREUM_LOCK";
    protected static final String BOREUM_PREF_NODE = "de/bos_bremen/governikus_boreum";
    protected static final String BOREUM_IE_PREF_NODE = "de/bos_bremen/governikus_boreum_ie";
    private static final String REPLACE_USE_PROXY = "@USE_PROXY@";
    private static final String REPLACE_PROXY_HOST = "@PROXY_HOST@";
    private static final String REPLACE_PROXY_PORT = "@PROXY_PORT@";
    private static final String REPLACE_LOG_PATH = "@LOG_PATH@";
    private static final String REPLACE_USER_LOCALE = "@USER_LOCALE@";
    private static final String REPLACE_BOREUM_VERSION = "@BOREUM_VERSION@";
    private File localAppFolder;
    protected final File lockfile;

    public BoreumStarter(File l) {
        this.localAppFolder = l;
        this.lockfile = new File(new File(System.getProperty("java.io.tmpdir")), LOCK_FILE);
    }

    public static boolean isBoreumIE() {
        return Boolean.getBoolean("boreum.ie");
    }

    private static void createVersionInstallDate() {
        Preferences licenceNode = BoreumStarter.isBoreumIE() ? Preferences.userRoot().node(BOREUM_IE_PREF_NODE) : Preferences.userRoot().node(BOREUM_PREF_NODE);
        if (licenceNode.get("period", null) == null) {
            licenceNode.put("period", Base64.getEncoder().encodeToString(new SimpleDateFormat("dd.MM.yyyy").format(new Date()).getBytes()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] processParameters(String[] args) {
        BoreumStarter.createVersionInstallDate();
        Preferences prefs = Preferences.userRoot().node("de");
        prefs = prefs.node("governikus");
        prefs = prefs.node("boreum");
        Preferences pref = prefs.node("dynamic_message");
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-") && !arg.equals("-view") && !arg.equals("-sign") && !arg.equals("-verify") && !arg.equals("-encrypt") && !arg.equals("-decrypt")) continue;
            arguments.add(arg);
        }
        long time = System.currentTimeMillis();
        int i = 0;
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            try {
                pref.put(time + "_" + i++, arg);
                it.remove();
            }
            catch (Exception e) {
                Logger.error((String)"", (Throwable)e);
            }
            finally {
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    Logger.error((String)"", (Throwable)e);
                }
            }
        }
        return args;
    }

    public void deleteFile(File fileToDelete) {
        if (!fileToDelete.exists()) {
            return;
        }
        if (fileToDelete.isDirectory()) {
            File[] files;
            for (File file : files = fileToDelete.listFiles()) {
                this.deleteFile(file);
            }
            try {
                Files.delete(fileToDelete.toPath());
            }
            catch (IOException e) {
                System.out.println(fileToDelete.getAbsolutePath() + " konnte nicht geloescht werden");
            }
        }
        try {
            Files.delete(fileToDelete.toPath());
        }
        catch (IOException e) {
            System.out.println(fileToDelete.getAbsolutePath() + " konnte nicht geloescht werden");
        }
    }

    private void extractDoc(File docFolder, File zipFile) {
        try (ZipFile docZip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> zipEntries = docZip.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry nextElement = zipEntries.nextElement();
                String zipEntryFileName = nextElement.getName();
                if (nextElement.isDirectory()) {
                    File storefolder = new File(docFolder, zipEntryFileName);
                    storefolder.mkdir();
                    continue;
                }
                File storeFile = new File(docFolder, zipEntryFileName);
                try {
                    InputStream inputStream = docZip.getInputStream(nextElement);
                    try (FileOutputStream outputStream = new FileOutputStream(storeFile);){
                        byte[] buffer = new byte[4096];
                        int readbytes = 0;
                        while ((readbytes = inputStream.read(buffer)) > 0) {
                            ((OutputStream)outputStream).write(buffer, 0, readbytes);
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void copyFile(File source, File targetFile) {
        if (source.isDirectory()) {
            return;
        }
        try (FileInputStream inS = new FileInputStream(source);){
            try (FileOutputStream outS = new FileOutputStream(targetFile);){
                byte[] buffer = new byte[2048];
                int readByte = 0;
                while ((readByte = inS.read(buffer)) > 0) {
                    outS.write(buffer, 0, readByte);
                }
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File replaceValues(File installedConfig) {
        Logger.debug((String)("Installierte Konfigurationsdatei : " + installedConfig.getAbsolutePath()));
        if (!installedConfig.exists()) {
            Logger.error((String)"... installierte Konfigurationsdatei wurde nicht gefunden. Bitte melden Sie dies dem Hersteller.");
        }
        try {
            File tmpConfigFile = File.createTempFile("tempBoreumConfigFile", ".xml");
            this.copyFile(installedConfig, tmpConfigFile);
            StringBuilder fileString = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new FileReader(tmpConfigFile));){
                String thisLine;
                while ((thisLine = br.readLine()) != null) {
                    if (thisLine.contains(REPLACE_USER_LOCALE)) {
                        thisLine = thisLine.replace(REPLACE_USER_LOCALE, BoreumStarter.checkUserLanguage());
                        fileString.append(thisLine);
                        continue;
                    }
                    if (thisLine.contains(REPLACE_USE_PROXY)) {
                        String useProxy = "";
                        if (System.getProperty("http.proxySet") != null && !System.getProperty("http.proxySet").isEmpty()) {
                            useProxy = System.getProperty("http.proxySet");
                        }
                        thisLine = thisLine.replace(REPLACE_USE_PROXY, useProxy);
                        fileString.append(thisLine);
                        continue;
                    }
                    if (thisLine.contains(REPLACE_PROXY_HOST)) {
                        String proxyHost = "";
                        if (System.getProperty("http.proxyHost") != null && !System.getProperty("http.proxyHost").isEmpty()) {
                            proxyHost = System.getProperty("http.proxyHost");
                        }
                        thisLine = thisLine.replace(REPLACE_PROXY_HOST, proxyHost);
                        fileString.append(thisLine);
                        continue;
                    }
                    if (thisLine.contains(REPLACE_PROXY_PORT)) {
                        String proxyPort = "";
                        if (System.getProperty("http.proxyPort") != null && !System.getProperty("http.proxyPort").isEmpty()) {
                            proxyPort = System.getProperty("http.proxyPort");
                        }
                        thisLine = thisLine.replace(REPLACE_PROXY_PORT, proxyPort);
                        fileString.append(thisLine);
                        continue;
                    }
                    if (thisLine.contains(REPLACE_BOREUM_VERSION)) {
                        String version = "";
                        try {
                            Project localeProject = new Project();
                            localeProject.load(this.localAppFolder, System.getProperty("update.filename"));
                            if (localeProject.getSoftware() != null && localeProject.getSoftware().getVersion() != null) {
                                version = localeProject.getSoftware().getVersion();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        thisLine = thisLine.replace(REPLACE_BOREUM_VERSION, version);
                        fileString.append(thisLine);
                        continue;
                    }
                    if (thisLine.contains(REPLACE_LOG_PATH)) {
                        String logPath = System.getProperty("java.io.tmpdir");
                        logPath = logPath.replace("\\", "/");
                        thisLine = thisLine.replace(REPLACE_LOG_PATH, logPath);
                        fileString.append(thisLine);
                        continue;
                    }
                    fileString.append(thisLine);
                }
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
            try (BufferedWriter textOut = new BufferedWriter(new FileWriter(tmpConfigFile));){
                textOut.write(fileString.toString());
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
            return tmpConfigFile;
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void installConfigFile() {
        File userConfigFile;
        Logger.debug((String)" try starterLocationURI ...  ");
        String starterLocationURI = null;
        try {
            starterLocationURI = BoreumStarter.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            Logger.debug((String)("starterLocationURI : " + starterLocationURI));
        }
        catch (URISyntaxException e) {
            Logger.debug(starterLocationURI, (Throwable)e);
        }
        String installDir = new File(starterLocationURI).getParent();
        Logger.debug((String)("installDir : " + installDir));
        String configFileName = "boreum.xml";
        if (BoreumStarter.isBoreumIE()) {
            configFileName = "boreumIE.xml";
        }
        if ((userConfigFile = new File(System.getProperty("user.home"), configFileName)).exists()) {
            return;
        }
        Logger.debug((String)("userConfigFile ist nicht vorhanden : " + userConfigFile.getAbsolutePath() + "\n\t kopiere installierte Konfiguration..."));
        File tmpFile = this.replaceValues(new File(installDir, configFileName));
        this.copyFile(tmpFile, userConfigFile);
        try {
            Files.delete(tmpFile.toPath());
        }
        catch (IOException e) {
            tmpFile.deleteOnExit();
        }
    }

    public void finished(boolean unzipDocs) {
        File libs;
        File zipFile;
        if (unzipDocs && (zipFile = new File(libs = new File(this.localAppFolder, "libs"), "doc.jar")).exists()) {
            File docFolder = new File(this.localAppFolder, "doc");
            this.deleteFile(docFolder);
            docFolder.mkdir();
            this.extractDoc(docFolder, zipFile);
            System.setProperty("boreum.helppath", "file:///" + docFolder.getAbsolutePath());
        }
        this.installConfigFile();
    }

    public void lock() {
        try {
            Utils.lock((File)this.lockfile);
        }
        catch (IOException e) {
            Logger.error((String)"", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::unlock));
    }

    public boolean isLocked() {
        return Utils.isLocked((File)this.lockfile);
    }

    public void unlock() {
        Utils.unlock((File)this.lockfile);
    }

    public boolean storeArguments(String[] args) {
        if (BoreumStarter.isBoreumIE()) {
            return true;
        }
        BoreumStarter.processParameters(args);
        return false;
    }

    private void startOfflineApp(String[] args) {
        try {
            Class<?> c = Class.forName("de.bos_bremen.ecard.client.gui.SignerMainStarter");
            Method main = c.getMethod("main", String[].class);
            main.invoke(c, new Object[]{args});
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static void delete(File f) {
        if (f == null || !f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                BoreumStarter.delete(file);
            }
        }
        BoreumStarter.deleteOutdated(f);
    }

    private static void deleteOutdated(File file) {
        Calendar c1 = Calendar.getInstance();
        c1.add(10, -1);
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(new Date(file.lastModified()).getTime());
        if (c1.after(c2)) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                Logger.error((String)("could not delete file: " + file));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        boolean startNewInstance;
        try {
            File tempDir = new File(System.getProperty("java.io.tmpdir"), "Governikus KG");
            tempDir = new File(tempDir, BoreumStarter.isBoreumIE() ? "GovernikusDataBoreumIE" : "GovernikusDataBoreumOffline");
            BoreumStarter.delete(tempDir);
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            File outFile = new File(tempDir, System.currentTimeMillis() + ".out.log");
            System.setOut(new PrintStream(outFile));
            File errFile = new File(tempDir, System.currentTimeMillis() + ".err.log");
            System.setErr(new PrintStream(errFile));
            System.setOut(new PrintStream(new File(tempDir, System.currentTimeMillis() + ".out.log")));
            System.setErr(new PrintStream(new File(tempDir, System.currentTimeMillis() + ".err.log")));
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
        }
        System.out.println("Current install dir: " + BoreumStarter.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        SecureRandom random = new SecureRandom();
        try {
            int nextInt = random.nextInt(4000);
            Logger.debug((String)("Wait " + nextInt + "ms to start main()."));
            Thread.sleep(nextInt);
        }
        catch (InterruptedException e) {
            Logger.debug((String)"Could't wait.");
            Thread.currentThread().interrupt();
        }
        if (System.getProperty("update.filename") == null) {
            System.setProperty("update.filename", "GovernikusBoreum.xml");
        }
        System.setProperty("user.language", BoreumStarter.checkUserLanguage());
        BoreumStarter s = new BoreumStarter(new File("appdata"));
        boolean wasLocked = s.isLocked();
        Logger.debug((String)("was locked: " + wasLocked));
        s.lock();
        if (wasLocked && !(startNewInstance = s.storeArguments(args))) {
            return;
        }
        s.installConfigFile();
        s.startOfflineApp(BoreumStarter.processParameters(args));
    }

    private static String checkUserLanguage() {
        String language = System.getProperty("user.language");
        if (!"de".equals(language) && !"en".equals(language)) {
            return "de";
        }
        return language;
    }
}

