/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.updater.boreum;

import de.governikus.updater.Step;
import de.governikus.updater.boreum.BoreumStarter;
import de.governikus.updater.client.Updater;
import de.governikus.updater.client.UpdaterController;
import de.governikus.updater.client.gui.DefaultGUIUpdateController;
import de.governikus.updater.client.gui.ErrorDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BaseMultiResolutionImage;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class BoreumController
extends DefaultGUIUpdateController
implements UpdaterController {
    private final JLabel progressControllerLabel = new JLabel(Step.READ.getLabel());
    private BoreumStarter starter = new BoreumStarter(this.updater.getLocalAppFolder());
    private boolean unzipDocs = true;

    public BoreumController(Updater u) {
        super(u, new File(new File(System.getProperty("java.io.tmpdir")), "BOREUM_LOCK"));
    }

    public void progress(Step s, long c, long count) {
        super.progress(s, c, count);
        if (s == Step.LOAD) {
            this.progressControllerLabel.setText(s.getLabel() + " " + c * 100L / count + " %");
        } else {
            this.progressControllerLabel.setText(s.getLabel() + " (" + c + " / " + count + ")");
        }
    }

    protected void showFrame(String appName) {
        if (this.frame != null) {
            return;
        }
        this.frame = new JFrame(appName);
        this.frame.setUndecorated(true);
        Toolkit tk = Toolkit.getDefaultToolkit();
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(tk.createImage(this.getImageResource("boreum_16.png")));
        icons.add(tk.createImage(this.getImageResource("boreum_32.png")));
        icons.add(tk.createImage(this.getImageResource("boreum_64.png")));
        icons.add(tk.createImage(this.getImageResource("boreum_128.png")));
        this.frame.setIconImages(icons);
        this.frame.setDefaultCloseOperation(3);
        JComponent contentPane = (JComponent)this.frame.getContentPane();
        contentPane.setBackground(new Color(231, 237, 246));
        contentPane.setLayout(new BorderLayout());
        ArrayList<Image> splashScreens = new ArrayList<Image>();
        for (int i = 100; i <= 300; i += 25) {
            String imageName = "splashscreen_xxx.gif".replace("xxx", String.valueOf(i));
            splashScreens.add(new ImageIcon(this.getImageResource(imageName)).getImage());
        }
        JLabel imageLabel = new JLabel(new ImageIcon(new BaseMultiResolutionImage(splashScreens.toArray(new Image[0]))));
        imageLabel.setOpaque(false);
        this.progressControllerLabel.setOpaque(false);
        contentPane.add((Component)imageLabel, "Center");
        contentPane.add((Component)this.progressControllerLabel, "South");
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public void will(Step step) {
        super.will(step);
        this.progressControllerLabel.setText(step.getLabel());
    }

    public void finished() {
        this.starter.finished(this.unzipDocs);
        super.finished();
    }

    public boolean storeArgumentsForAlreadyStartedApp(String[] args) {
        return this.starter.storeArguments(args);
    }

    private URL getImageResource(String imageName) {
        Object path = "/" + BoreumController.class.getName().replace('.', '/');
        path = ((String)path).substring(0, ((String)path).lastIndexOf("/"));
        path = (String)path + "/images/";
        return BoreumController.class.getResource((String)path + imageName);
    }

    public String[] processParameters(String[] args) {
        return BoreumStarter.processParameters(args);
    }

    public UpdaterController.NoRemoteProjectResult errorNoRemoteProject(IOException c, boolean couldRunLocal, URI uri) {
        this.cause = c;
        List<Proxy> select = ProxySelector.getDefault().select(uri);
        int result = select != null && !select.isEmpty() ? new ErrorDialog(this.frame, this.cause, select.get(0), couldRunLocal).getResult() : new ErrorDialog(this.frame, this.cause, null, couldRunLocal).getResult();
        if (result == 0) {
            this.cause = null;
            return UpdaterController.NoRemoteProjectResult.RUN_LOCAL;
        }
        return UpdaterController.NoRemoteProjectResult.QUIT;
    }

    public boolean resetProxySelector() {
        return true;
    }

    public void quit() {
    }

    public boolean mustCheck() {
        this.unzipDocs = super.mustCheck();
        return this.unzipDocs;
    }

    static {
        if (System.getProperty("update.filename") == null) {
            System.setProperty("update.filename", "GovernikusBoreum.xml");
        }
        if (System.getProperty("manufacturer.name") == null) {
            System.setProperty("manufacturer.name", "Governikus KG");
        }
        if (System.getProperty("boreum.ie") == null) {
            System.setProperty("boreum.ie", "false");
        }
    }
}

