/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management.service.mcard.res;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.KeyFunction;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.LockableResourceState;
import de.governikus.csl.uom.res.PrivateKeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceFailedException;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.impl.DelegateLockableResourceStateImpl;
import de.governikus.csl.uom.res.impl.DelegateResourceReferenceStateImpl;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardConstants;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardPrivateKeyResourceReferenceImpl;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourceCardRelatedException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinBlockedException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinInputCancelledException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinInputTimeoutException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinNotInitializedException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinOperationCancelledException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinTooLongException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinTooShortException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourcePinWrongException;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourceReferenceState;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourceState;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardResourceTerminalRelatedException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;

public class MCardPrivateKeyResourceImpl
extends PrivateKeyResourceImpl
implements MCardResourceState {
    private static final long serialVersionUID = 1L;
    private final GovCS cardService;
    private final OCFPrivateKey ocfKey;
    private final boolean multiSign;
    private final boolean stapleSign;
    private final Integer stapleSignCounter;
    private boolean locked = false;
    private Object lock;
    private LockState lockState = LockState.NONE;
    private boolean enabled = true;

    public MCardPrivateKeyResourceImpl(String alias, OCFPrivateKey privateKey, String jceProviderName, Certificate certificate, ResourceAreaType resourceArea) {
        this(alias, privateKey, jceProviderName, certificate == null ? null : Collections.singletonList(certificate), resourceArea);
    }

    public MCardPrivateKeyResourceImpl(String alias, OCFPrivateKey privateKey, String jceProviderName, List<Certificate> certificateChain, ResourceAreaType resourceArea) {
        super((PrivateKeyResourceReference)new MCardPrivateKeyResourceReferenceImpl(alias, (DelegateResourceReferenceStateImpl<MCardResourceReferenceState>)new DelegateResourceReferenceStateImpl(), MCardPrivateKeyResourceImpl.createCertificateChain(certificateChain, privateKey), MCardPrivateKeyResourceImpl.getSupportedAlgorithm(privateKey), resourceArea), (ResourceState)new DelegateLockableResourceStateImpl(null), (PrivateKey)privateKey, true, jceProviderName);
        this.ocfKey = privateKey;
        this.cardService = privateKey.getCardService();
        DelegateLockableResourceStateImpl dState = (DelegateLockableResourceStateImpl)super.getState();
        dState.setDelegate((LockableResourceState)this);
        ((DelegateResourceReferenceStateImpl)super.getReference().getState()).setResourceState((ResourceReferenceState)this);
        this.multiSign = this.cardService.isMultiSign();
        this.stapleSign = this.cardService.isStapleSign();
        this.stapleSignCounter = this.multiSign ? MCardConstants.UNLIMITED_STAPLE_SIGN_COUNTER : (this.stapleSign ? this.cardService.getStapleSignCounter() : MCardConstants.DEFAULT_STAPLE_SIGN_COUNTER);
    }

    private static List<KeyFunctionSupportedAlgorithms> getSupportedAlgorithm(OCFPrivateKey privateKey) {
        ArrayList<KeyFunctionSupportedAlgorithms> result = new ArrayList<KeyFunctionSupportedAlgorithms>();
        MCardPrivateKeyResourceImpl.add(result, privateKey, KeyFunction.SIGN, UsageRelated.Usage.SIGNATURE);
        MCardPrivateKeyResourceImpl.add(result, privateKey, KeyFunction.AUTHENTICATE, UsageRelated.Usage.AUTHENTICATION);
        MCardPrivateKeyResourceImpl.add(result, privateKey, KeyFunction.DECRYPT, UsageRelated.Usage.CIPHER, UsageRelated.Usage.KEYAGREEMENT);
        MCardPrivateKeyResourceImpl.add(result, privateKey, KeyFunction.ENCRYPT, UsageRelated.Usage.CIPHER, UsageRelated.Usage.KEYAGREEMENT);
        return result;
    }

    private static void add(List<KeyFunctionSupportedAlgorithms> list, OCFPrivateKey privateKey, KeyFunction keyFunction, UsageRelated.Usage ... usages) {
        MCardPrivateKeyResourceImpl.add(list, privateKey, keyFunction, usages == null || usages.length == 0 ? Collections.emptyList() : Arrays.asList(usages));
    }

    private static void add(List<KeyFunctionSupportedAlgorithms> list, OCFPrivateKey privateKey, KeyFunction keyFunction, List<UsageRelated.Usage> usages) {
        for (UsageRelated.Usage usage : usages) {
            List algorithms = privateKey.getAlgorithms(usage);
            ArrayList<String> supportedAlgorithms = new ArrayList<String>();
            for (Algorithm algorithm : algorithms) {
                String algorithmName = algorithm.getAlgorithmName();
                if (algorithmName.contains("hashedWith")) continue;
                supportedAlgorithms.add(XMLOIDJCEAlgorithmMapper.getCSLAlgorithmURI((String)algorithmName));
            }
            if (supportedAlgorithms.isEmpty()) continue;
            list.add(new KeyFunctionSupportedAlgorithms(keyFunction, supportedAlgorithms));
        }
    }

    public static List<Certificate> createCertificateChain(List<Certificate> extCertificateChain, OCFPrivateKey privateKey) {
        if (extCertificateChain != null && !extCertificateChain.isEmpty()) {
            return extCertificateChain;
        }
        if (privateKey != null) {
            OCFCertificateInfo ocfCertificatInfo = privateKey.getOCFCertificatInfo();
            if (ocfCertificatInfo == null) {
                throw new IllegalArgumentException("OCFPrivateKey unusable, because no OCFCertificateInfo is provided");
            }
            X509Certificate x509Certificate = ocfCertificatInfo.getX509Certificate();
            if (x509Certificate == null) {
                throw new IllegalArgumentException("OCFPrivateKey unusable, because no certificate is provided");
            }
            return Collections.singletonList(x509Certificate);
        }
        throw new IllegalArgumentException("at least one of the following is required: an external certificate chain or an OCFPrivateKey with certificate");
    }

    public boolean isLocked() {
        return this.locked;
    }

    public synchronized boolean lock(Object lock, LockState mode) throws ResourceFailedException {
        if (this.isLocked()) {
            throw new IllegalStateException("can not lock resource");
        }
        switch (mode) {
            case EXCLUSIVE_LAZY: {
                this.cardService.beginTransaction();
                break;
            }
            case EXCLUSIVE: {
                this.cardService.beginTransaction();
                if (!this.multiSign && !this.stapleSign) break;
                try {
                    this.cardService.verifyPassword(this.ocfKey.getOCFCertificatInfo(), null);
                    break;
                }
                catch (PinInputCancelledException e) {
                    throw new MCardResourcePinInputCancelledException(this.resourceReference, e);
                }
                catch (PinInputTooShortException e) {
                    throw new MCardResourcePinTooShortException(this.resourceReference, e);
                }
                catch (PinInputTooLongException e) {
                    throw new MCardResourcePinTooLongException(this.resourceReference, e);
                }
                catch (PinInputTimeoutException e) {
                    throw new MCardResourcePinInputTimeoutException(this.resourceReference, e);
                }
                catch (OperationCancelledException e) {
                    throw new MCardResourcePinOperationCancelledException(this.resourceReference, e);
                }
                catch (WrongPinException e) {
                    throw new MCardResourcePinWrongException(this.resourceReference, e);
                }
                catch (RetryCounterExpiredException e) {
                    throw new MCardResourcePinBlockedException(this.resourceReference, e);
                }
                catch (NotYetInitializedException e) {
                    throw new MCardResourcePinNotInitializedException(this.resourceReference, e);
                }
                catch (ResponseCodeException e) {
                    throw new MCardResourceCardRelatedException(this.resourceReference, e);
                }
                catch (CardTerminalException e) {
                    throw new MCardResourceTerminalRelatedException(this.resourceReference, e);
                }
                catch (InvalidCardChannelException e) {
                    throw new MCardResourceTerminalRelatedException(this.resourceReference, e);
                }
            }
            case SHARED: {
                break;
            }
            case NONE: {
                return false;
            }
        }
        this.lock = lock;
        this.lockState = mode;
        this.locked = true;
        return this.locked;
    }

    public synchronized boolean unlock(Object lock, LockState state) {
        if (!this.isLocked()) {
            throw new IllegalStateException("can not unlock resource");
        }
        this.lock = lock;
        this.locked = false;
        switch (this.lockState) {
            case EXCLUSIVE_LAZY: 
            case EXCLUSIVE: {
                this.cardService.endTransaction(true);
                break;
            }
        }
        this.lockState = LockState.NONE;
        return !this.locked;
    }

    public boolean isPresent() {
        return true;
    }

    public boolean isAbsent() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return true;
    }

    public LockState getLockState() {
        return this.lockState;
    }

    @Override
    public boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign;
    }

    @Override
    public Integer getStapleSignCounter() {
        return this.stapleSignCounter;
    }

    public void setLockState(LockState lockState) {
        this.lockState = lockState;
    }
}

