/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res.management.service.mcard;

import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreParameterInputStream;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.ConfigurationManager;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.ServiceResourceReference;
import de.governikus.csl.uom.res.ServiceResourceReferenceState;
import de.governikus.csl.uom.res.impl.ObjectConfigurationType;
import de.governikus.csl.uom.res.impl.ServiceResourceReferenceImpl;
import de.governikus.csl.uom.res.management.ResourceProviderService;
import de.governikus.csl.uom.res.management.ResourceRegistry;
import de.governikus.csl.uom.res.management.service.mcard.res.MCardPrivateKeyResourceImpl;
import de.governikus.csl.uom.service.AbstractService;
import de.governikus.csl.uom.service.Service;
import de.governikus.csl.uom.service.ServiceType;
import de.governikus.csl.uom.types.Configuration;
import de.governikus.csl.uom.types.ConfigurationInfo;
import de.governikus.csl.uom.types.ConfigurationInfoType;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import opencard.core.service.SmartCard;

@ServiceType(id=Service.ServiceID.INVISIBLE_RESOURCE_PROVIDER, type=ResourceProviderService.class)
public class MCardSingletonResourceProviderService
extends AbstractService
implements ResourceProviderService {
    private static final List<ConfigurationInfoType> CONFIGURATION_INFOS = Collections.unmodifiableList(Arrays.asList(ObjectConfigurationType.RESOURCE_AREA_CONFIGURATION_INFO, ObjectConfigurationType.SERVICE_RESOURCE_COMPONENT_CONFIGURATION_INFO));
    private static final Logger LOG = Logger.getLogger(MCardSingletonResourceProviderService.class.getName());
    public static final String SERVICE_NAME = "mcard-resource-provider-service";
    private final OCFKeyStoreParameterInputStream keyStoreLoadStream;
    private final KeyStore ocfKeystore;
    private Object registryLock;
    private ResourceRegistry registry;
    private final Map<String, Resource> resourceMap;
    private final ServiceResourceReference serviceResourceReference;
    private Configuration<ResourceAreaType> resourceAreaConfiguration = ObjectConfigurationType.RESOURCE_AREA_CONFIGURATION_DEFAULT;
    private Configuration<ResourceComponentType> serviceResourceComponentConfiguration = ObjectConfigurationType.SERVICE_RESOURCE_COMPONENT_CONFIGURATION_DEFAULT;
    private static MCardSingletonResourceProviderService singleton;

    private MCardSingletonResourceProviderService() {
        super(SERVICE_NAME);
        this.initJCESecurity();
        this.resourceMap = new HashMap<String, Resource>();
        this.ocfKeystore = this.initKeyStore();
        this.keyStoreLoadStream = this.loadKeyStore();
        this.initConfigurations();
        this.serviceResourceReference = new ServiceResourceReferenceImpl(SERVICE_NAME, (ResourceComponentType)this.serviceResourceComponentConfiguration.toObject(), (ResourceAreaType)this.resourceAreaConfiguration.toObject(), MCardSingletonResourceProviderService.class.getName(), new ServiceResourceReferenceState(){

            public boolean isPresent() {
                return true;
            }

            public boolean isEnabled() {
                return MCardSingletonResourceProviderService.this.isEnabled();
            }

            public boolean isAbsent() {
                return false;
            }

            public boolean isStarted() {
                return MCardSingletonResourceProviderService.this.isStarted();
            }

            public LockState getLockState() {
                return LockState.NONE;
            }
        });
        ((ServiceResourceReferenceImpl)this.serviceResourceReference).setConfigurable(true);
        ((ServiceResourceReferenceImpl)this.serviceResourceReference).setConfigurationInfo(CONFIGURATION_INFOS);
    }

    private void initConfigurations() {
        Configuration lConfigurationArea;
        Configuration lConfigurationComponent = ConfigurationManager.getManager().get(ResourceComponentType.class, (ConfigurationInfo)ObjectConfigurationType.SERVICE_RESOURCE_COMPONENT_CONFIGURATION_INFO);
        if (lConfigurationComponent != null) {
            this.serviceResourceComponentConfiguration = lConfigurationComponent;
        }
        if ((lConfigurationArea = ConfigurationManager.getManager().get(ResourceAreaType.class, (ConfigurationInfo)ObjectConfigurationType.RESOURCE_AREA_CONFIGURATION_INFO)) != null) {
            this.resourceAreaConfiguration = lConfigurationArea;
        }
    }

    private void initJCESecurity() {
        if (Security.getProvider("OCF") == null) {
            Security.addProvider((Provider)new OCFProvider());
        }
        CryptoProviderUtil.registerBouncyCastleIfNotAvailable();
    }

    private OCFKeyStoreParameterInputStream loadKeyStore() {
        OCFKeyStoreParameterInputStream tmpKeyStoreLoadStream = new OCFKeyStoreParameterInputStream();
        if (this.ocfKeystore == null) {
            return tmpKeyStoreLoadStream;
        }
        tmpKeyStoreLoadStream.setOCFKeyStoreListener(new OCFKeyStoreListener(){

            public void aliasRemoved(String alias) {
                if (!MCardSingletonResourceProviderService.this.started) {
                    return;
                }
                LOG.fine("removed: " + alias);
                Resource resource = MCardSingletonResourceProviderService.this.resourceMap.remove(alias);
                if (MCardSingletonResourceProviderService.this.registry.removeResource((Object)MCardSingletonResourceProviderService.this, MCardSingletonResourceProviderService.this.registryLock, resource)) {
                    LOG.fine("removed: " + alias);
                } else {
                    LOG.fine("removed failed: " + alias);
                }
            }

            public void aliasAdded(String alias) {
                LOG.fine("added: " + alias);
                try {
                    Resource resource = MCardSingletonResourceProviderService.this.createResource(alias);
                    if (resource != null && MCardSingletonResourceProviderService.this.registry.getFilter().accept((ResourceReferenceParameter)resource)) {
                        LOG.fine("adding resource");
                        Runnable run = () -> {
                            MCardSingletonResourceProviderService.this.resourceMap.put(alias, resource);
                            if (MCardSingletonResourceProviderService.this.registry.addResource((Object)MCardSingletonResourceProviderService.this, MCardSingletonResourceProviderService.this.registryLock, resource)) {
                                LOG.fine("added at registry: " + alias);
                            }
                        };
                        new Thread(run).start();
                    } else {
                        LOG.fine("ignoring alias (" + (resource != null) + "): " + alias);
                    }
                }
                catch (Exception e) {
                    LOG.fine("failed to create resource");
                }
            }
        });
        return tmpKeyStoreLoadStream;
    }

    private KeyStore initKeyStore() {
        KeyStore tmpKeyStore = null;
        try {
            tmpKeyStore = KeyStore.getInstance("OCF", "OCF");
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            LOG.severe("failed to load MCard keystore: " + e.getMessage());
        }
        return tmpKeyStore;
    }

    private Resource createResource(String alias) {
        if (!this.started) {
            return null;
        }
        if (alias == null || alias.isEmpty()) {
            return null;
        }
        Certificate certificate = null;
        PrivateKey privateKey = null;
        try {
            certificate = this.ocfKeystore.getCertificate(alias);
            privateKey = (PrivateKey)this.ocfKeystore.getKey(alias, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (certificate == null || privateKey == null) {
            return null;
        }
        String name = alias;
        return new MCardPrivateKeyResourceImpl(name, (OCFPrivateKey)privateKey, "OCF", certificate, (ResourceAreaType)this.resourceAreaConfiguration.toObject());
    }

    public String getID() {
        return SERVICE_NAME;
    }

    public synchronized boolean startService(Object registryLock, ResourceRegistry registry) {
        if (this.ocfKeystore == null) {
            return false;
        }
        this.started = true;
        this.registryLock = registryLock;
        this.registry = registry;
        try {
            this.registry.addResource((Object)this, this.registryLock, (Resource)this);
            this.ocfKeystore.load((InputStream)this.keyStoreLoadStream, null);
            if (!SmartCard.isStarted()) {
                throw new RuntimeException("failed to start MCard - missing native library?");
            }
        }
        catch (Exception e) {
            this.registry.removeResource((Object)this, this.registryLock, (Resource)this);
            for (Map.Entry<String, Resource> entry : this.resourceMap.entrySet()) {
                this.registry.removeResource((Object)this, this.registryLock, entry.getValue());
            }
            this.resourceMap.clear();
            this.registry = null;
            this.registryLock = null;
            this.started = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopService(Object registryLock) {
        if (this.registryLock != registryLock) {
            throw new IllegalStateException("illegal lock used for stopping service");
        }
        try {
            for (Map.Entry<String, Resource> entry : this.resourceMap.entrySet()) {
                this.registry.removeResource((Object)this, this.registryLock, entry.getValue());
            }
            this.ocfKeystore.store(null, null);
        }
        catch (Exception exception) {
        }
        finally {
            this.resourceMap.clear();
            this.registry = null;
            this.registryLock = null;
            this.started = false;
        }
    }

    protected boolean setEnabledInt(boolean enabled) {
        this.enabled = enabled;
        return true;
    }

    public static synchronized MCardSingletonResourceProviderService getInstance() {
        if (singleton == null) {
            singleton = new MCardSingletonResourceProviderService();
        }
        return singleton;
    }

    public ResourceReference getReference() {
        return this.serviceResourceReference;
    }

    public ResourceState getState() {
        return this;
    }

    public boolean isPresent() {
        return true;
    }

    public boolean isAbsent() {
        return false;
    }

    public boolean isConfigurable() {
        return this.serviceResourceReference.isConfigurable();
    }

    public List<? extends ConfigurationInfo> getConfigurationInfo() {
        return this.serviceResourceReference.getConfigurationInfo();
    }

    public <C extends Configuration<?>> boolean configure(Object registryLock, C configuration) {
        if (this.registryLock != registryLock) {
            throw new IllegalStateException("illegal lock used for configuring service");
        }
        if (configuration == null) {
            return false;
        }
        if (ObjectConfigurationType.RESOURCE_AREA_CONFIGURATION_INFO.equals((Object)configuration.getInfo())) {
            this.resourceAreaConfiguration = (ObjectConfigurationType)configuration;
        }
        if (ObjectConfigurationType.SERVICE_RESOURCE_COMPONENT_CONFIGURATION_INFO.equals((Object)configuration.getInfo())) {
            this.serviceResourceComponentConfiguration = (ObjectConfigurationType)configuration;
        }
        return true;
    }
}

