/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.service.ports;

import de.bos_bremen.ecard.client.webservice.service.ports.MultiClient;
import de.bos_bremen.ecard.client.webservice.service.ports.ServiceRequest;
import de.bos_bremen.ecard.client.webservice.service.ports.ServiceResponse;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class PortRange {
    private int timeToRelease = 86400000;
    private static final Logger LOG = LogManager.getLogger(PortRange.class);
    private HashMap<ServiceRequest, ServiceResponse> servicePortMap = new HashMap();
    private List<Integer> freePortPool = new ArrayList<Integer>();

    PortRange(int firstUsePort, int portRange) {
        LOG.info("firstPort={} : portRange={}", (Object)firstUsePort, (Object)portRange);
        for (int i = firstUsePort; i < firstUsePort + portRange; i += 2) {
            this.freePortPool.add(i);
        }
    }

    int getPort(String clientName, String userName, MultiClient.application applicationName) {
        LOG.info("USERNAME={} CLIENTNAME={}", (Object)userName, (Object)clientName);
        if (applicationName == null) {
            LOG.error("application darf nicht null sein : application.BOREUM_IE wird verwendet");
        }
        ServiceRequest serviceRequest = new ServiceRequest(userName.toUpperCase(), clientName.toUpperCase());
        ServiceResponse serviceResponse = null;
        if (this.servicePortMap.containsKey(serviceRequest)) {
            serviceResponse = this.servicePortMap.get(serviceRequest);
            LOG.info("Request  = {} ", (Object)serviceRequest);
            LOG.info("Response = {} ", (Object)serviceResponse);
            serviceResponse.setLastRequestDate();
        } else {
            if (this.freePortPool.isEmpty()) {
                LOG.info("Pool is empty. --> call gc");
                this.gc();
                if (this.freePortPool.isEmpty()) {
                    LOG.error("No free Ports in the Pool");
                    return -1;
                }
            }
            Integer newPortnumber = -1;
            for (Integer port : this.freePortPool) {
                try {
                    ServerSocket serverSocket = new ServerSocket(port);
                    serverSocket.close();
                    newPortnumber = port;
                    LOG.debug("Free port found : port = {}", (Object)port);
                    break;
                }
                catch (BindException exc) {
                    LOG.error("Port {}", (Object)(port + "should be free, but there is a BindException"));
                }
                catch (IOException exc) {
                    LOG.error("Port {}", (Object)(port + "should be free, but there is a IOException"));
                }
            }
            if (newPortnumber < 0) {
                LOG.error("Could not find a free Port in the Pool");
                return -1;
            }
            serviceResponse = new ServiceResponse(newPortnumber);
            this.servicePortMap.put(serviceRequest, serviceResponse);
            LOG.info("Request : {}", (Object)serviceRequest);
            LOG.info("Response: {}", (Object)serviceResponse);
            this.freePortPool.remove(newPortnumber);
        }
        int userPort = serviceResponse.portNumber + MultiClient.application.GovernikusIntegratedSigner.getPortOffset();
        LOG.info("{}{}{}{}", (Object)"Port: ", (Object)userPort, (Object)" for request: ", (Object)serviceRequest);
        return userPort;
    }

    private void gc() {
        long lastRequestDate = System.currentTimeMillis() - (long)this.timeToRelease;
        Set<Map.Entry<ServiceRequest, ServiceResponse>> entrySet = this.servicePortMap.entrySet();
        ArrayList<ServiceRequest> releasePorts = new ArrayList<ServiceRequest>();
        for (Map.Entry<ServiceRequest, ServiceResponse> entry : entrySet) {
            if (lastRequestDate <= entry.getValue().getLastRequestDate().getTime()) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info("LastRequest to early {}{}", (Object)DateFormat.getDateTimeInstance().format(entry.getValue().getLastRequestDate()), (Object)" release this Port");
            }
            int port = -1;
            try {
                port = entry.getValue().portNumber + MultiClient.application.GovernikusSigner.getPortOffset();
                ServerSocket serverSocketSigner = new ServerSocket(port);
                serverSocketSigner.close();
                port = entry.getValue().portNumber + MultiClient.application.GovernikusIntegratedSigner.getPortOffset();
                ServerSocket serverSocketSignerIntegration = new ServerSocket(port);
                serverSocketSignerIntegration.close();
                releasePorts.add(entry.getKey());
            }
            catch (BindException exc) {
                LOG.error("Port {}", (Object)(port + "should be free, but there is a BindException"));
            }
            catch (IOException exc) {
                LOG.error("Port {}", (Object)(port + "should be free, but there is a IOException"));
            }
        }
        for (ServiceRequest serviceRequest : releasePorts) {
            ServiceResponse serviceResponse = this.servicePortMap.get(serviceRequest);
            this.servicePortMap.remove(serviceRequest);
            this.freePortPool.add(serviceResponse.portNumber);
            LOG.info("release the Port {}{}", (Object)serviceResponse.portNumber, (Object)" into the pool");
        }
    }

    void setTimeToRelease(int timeToRelease) {
        this.timeToRelease = timeToRelease;
    }
}

