/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.service.ports;

import de.bos_bremen.ecard.client.webservice.service.ports.PortRange;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.Endpoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebService(targetNamespace="governikus.service")
@SOAPBinding(style=SOAPBinding.Style.RPC)
public class MultiClient {
    private static final int DEFAULT_FIRST_PORT = 8087;
    private static final int DEFAULT_PORTRANGE = 300;
    private static final Logger LOG = LogManager.getLogger(MultiClient.class);
    private PortRange portRange;
    private static final String HTTP = "http://";

    public MultiClient() {
        this.createWS();
    }

    @WebMethod
    @WebResult(partName="return")
    public int getCurrentPort(@WebParam(name="application") application aPplication, @WebParam(name="username") String username, @WebParam(name="clientName") String clientName, @WebParam(name="sessionName") String sessionName) {
        LOG.info("getCurrentPort for ...");
        LOG.info("username     : {}", (Object)username);
        LOG.info("clientName   : {}", (Object)clientName);
        if (username == null || username.isEmpty()) {
            LOG.fatal("username darf nicht leer sein. ");
        }
        if (clientName == null || clientName.isEmpty()) {
            LOG.fatal("clientname darf nicht leer sein. ");
        }
        if (aPplication == null) {
            LOG.error("application darf nicht null sein : application.GovernikusIntegratedSigner wird verwendet.");
        }
        return this.portRange.getPort(clientName, username, application.GovernikusIntegratedSigner);
    }

    private void createWS() {
        Endpoint endpoint = Endpoint.create((Object)this);
        Map<String, String> systemGetEnv = System.getenv();
        LOG.info("Search SERVICEPORT in system ... ");
        String systemServicePort = System.getProperty("SERVICEPORT", systemGetEnv.get("SERVICEPORT"));
        int systemServiceport = 8086;
        try {
            LOG.info("Try to get serviceport from the system SERVICEPORT = {}", (Object)systemServicePort);
            systemServiceport = Integer.parseInt(systemServicePort);
            LOG.info("Found in system : SERVICEPORT = {}", (Object)systemServiceport);
        }
        catch (NumberFormatException ex) {
            systemServiceport = 8086;
            LOG.info("It is used by default : SERVICEPORT = {}", (Object)systemServiceport);
        }
        int systemPortrange = 300;
        try {
            systemPortrange = Integer.parseInt(System.getProperty("PORTRANGE", systemGetEnv.get("PORTRANGE")));
            LOG.info("Found in system = {}", (Object)systemPortrange);
        }
        catch (NumberFormatException ex) {
            systemPortrange = 300;
            LOG.info("Used default PORTRANGE = {}", (Object)systemPortrange);
        }
        int systemFirstport = 8087;
        try {
            LOG.info("Search FIRSTPORT in system ... ");
            systemFirstport = Integer.parseInt(System.getProperty("FIRSTPORT", systemGetEnv.get("FIRSTPORT")));
            LOG.info("Found in system : FIRSTPORT = {}", (Object)systemFirstport);
        }
        catch (NumberFormatException ex) {
            systemFirstport = 8087;
            LOG.info("Used default FIRSTPORT = {}", (Object)systemFirstport);
        }
        this.portRange = new PortRange(systemFirstport, systemPortrange);
        String localHost = "0.0.0.0";
        endpoint.publish(HTTP + localHost + ":" + systemServiceport + "/servicePorts");
        LOG.info("Published on {}{}{}{}{}", (Object)HTTP, (Object)localHost, (Object)":", (Object)systemServiceport, (Object)"/servicePorts");
        LOG.info("WSDL on {}{}{}{}{}", (Object)HTTP, (Object)localHost, (Object)":", (Object)systemServiceport, (Object)"/servicePorts?wsdl");
    }

    public static void main(String ... strings) {
        new MultiClient();
    }

    public static void stop() {
        System.exit(0);
    }

    static enum application {
        GovernikusIntegratedSigner(1),
        GovernikusSigner(0);

        int offset = 0;

        private application(int offset) {
            this.offset = offset;
        }

        int getPortOffset() {
            return this.offset;
        }
    }
}

