/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.client.service.ports;

import de.bos_bremen.ecard.client.webservice.client.service.ports.Application;
import de.bos_bremen.ecard.client.webservice.client.service.ports.MultiClient;
import de.bos_bremen.ecard.client.webservice.client.service.ports.MultiClientService;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortUtils {
    private static final Logger LOG = LogManager.getLogger(PortUtils.class);
    private static final String CONSOLE = "Console";

    private PortUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static URL generateSignerServiceWSDL(Application application2, boolean useNullBinding) {
        if (application2 == null) {
            LOG.error("Application darf nicht null sein : Application.GOVERNIKUS_INTEGRATED_SIGNER wird verwendet..");
        }
        String localHost = "0.0.0.0";
        if (!useNullBinding) {
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.error("", (Throwable)e);
            }
        }
        LOG.debug("localhost={}", (Object)localHost);
        return PortUtils.generateSignerServiceWSDL(Application.GOVERNIKUS_INTEGRATED_SIGNER, localHost, true);
    }

    private static URL generateSignerServiceWSDL(Application application2, String host, boolean dynamicPorts) {
        LOG.debug("Application={} host={} dynamicPorts={}", (Object)application2, (Object)host, (Object)dynamicPorts);
        if (application2 == null) {
            LOG.error("Application darf nicht null sein : {} wird verwendet.", (Object)Application.GOVERNIKUS_INTEGRATED_SIGNER);
        }
        int port = 8088;
        String servicePortString = System.getProperty("SERVICEPORT", System.getenv("SERVICEPORT"));
        LOG.debug("Try System env SERVICEPORT = {}", (Object)servicePortString);
        if (servicePortString != null) {
            port = Integer.parseInt(servicePortString);
        }
        if (dynamicPorts) {
            Map<String, String> enviroment = System.getenv();
            String clientName = System.getProperty("CLIENTNAME", enviroment.get("CLIENTNAME"));
            String sessionName = System.getProperty("SESSIONNAME", enviroment.get("SESSIONNAME"));
            String username = System.getProperty("user.name");
            LOG.info("USERNAME={} SESSIONNAME={} CLIENTNAME={}", (Object)username, (Object)sessionName, (Object)clientName);
            if (!(clientName == null || clientName.isEmpty() || sessionName == null || sessionName.isEmpty() || CONSOLE.equals(sessionName))) {
                LOG.info("Try to get MultiClient ...");
                MultiClient multiService = PortUtils.getMultiClientService();
                if (multiService == null) {
                    String errorMessage = "\nIE requires the MultiClient Service in RDP and terminal server environments.\nIE cannot connect MultiClient Service.\nStart Governikus DATA Boreum MultiClient.exe";
                    LOG.error(errorMessage);
                    throw new RuntimeException(errorMessage, new ConnectException());
                }
                do {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)e, (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                } while ((multiService = PortUtils.getMultiClientService()) == null);
                port = multiService.getCurrentPort(Application.GOVERNIKUS_INTEGRATED_SIGNER, username, clientName, sessionName);
                LOG.info("Terminal server. IE port = {}", (Object)port);
            } else {
                LOG.info("IE local.");
            }
        }
        URL url = null;
        try {
            url = new URL("http://" + host + ":" + port + "/signer?wsdl");
        }
        catch (MalformedURLException e) {
            LOG.error("", (Throwable)e);
        }
        LOG.info("IE WebServiceURL {}", (Object)url);
        return url;
    }

    public static MultiClient getMultiClientService() {
        MultiClientService service = null;
        MultiClient multiClientInstance = null;
        try {
            service = new MultiClientService();
            LOG.info("MultiClientService wird ausgefuert: {}", (Object)service.getWSDLDocumentLocation());
            multiClientInstance = service.getMultiClientServicePort();
        }
        catch (RuntimeException ex) {
            if (service == null) {
                LOG.error("Governikus DATA Boreum MultiClient Dienst wird nicht ausgefuert : {}", (Object)ex.getMessage());
                LOG.info("Starten Sie : Governikus DATA Boreum MultiClient.exe in C:/Program Files (x86)/Governikus KG/DATA Boreum MultiClient/");
            }
            LOG.debug((Object)ex, (Throwable)ex);
        }
        return multiClientInstance;
    }
}

