/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ecard.client.webservice.client.service.ports;

import de.bos_bremen.ecard.client.webservice.client.service.ports.MultiClient;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebServiceClient(name="MultiClientService", targetNamespace="governikus.service", wsdlLocation="http://127.0.0.1:8086/servicePorts?wsdl")
public class MultiClientService
extends Service {
    private static final Logger LOG = LogManager.getLogger(MultiClientService.class);
    private static final URL MULTI_CLIENT_SERVICE_WSDL_LOCATION;

    public MultiClientService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public MultiClientService() {
        super(MULTI_CLIENT_SERVICE_WSDL_LOCATION, new QName("governikus.service", "MultiClientService"));
        LOG.info("MultiClientService ist erstellt : {}", (Object)MULTI_CLIENT_SERVICE_WSDL_LOCATION);
    }

    @WebEndpoint(name="MultiClientServicePort")
    public MultiClient getMultiClientServicePort() {
        return (MultiClient)super.getPort(new QName("governikus.service", "MultiClientPort"), MultiClient.class);
    }

    @WebEndpoint(name="MultiClientServicePort")
    public MultiClient getMultiClientServicePort(WebServiceFeature ... features) {
        return (MultiClient)super.getPort(new QName("governikus.service", "MultiClientPort"), MultiClient.class, features);
    }

    static {
        String servicePortString = System.getProperty("SERVICEPORT", System.getenv("SERVICEPORT"));
        LOG.info("System env SERVICEPORT = {}", (Object)servicePortString);
        if (servicePortString == null) {
            servicePortString = "8086";
        }
        LOG.info("Try to get ServicePort SERVICEPORT {} ...", (Object)servicePortString);
        int port = 8086;
        try {
            port = Integer.parseInt(servicePortString);
            LOG.info("The SERVICEPORT is used : {}", (Object)port);
        }
        catch (NumberFormatException ex) {
            LOG.info("System env SERVICEPORT don't found. The default SERVICEPORT ist used : 8086");
            port = 8086;
        }
        String localHost = "localhost";
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        URL url = null;
        try {
            url = new URL("http://" + localHost + ":" + port + "/servicePorts?wsdl");
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        LOG.info("Multi Client Service URL soll: {}", (Object)url);
        MULTI_CLIENT_SERVICE_WSDL_LOCATION = url;
    }
}

