/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSigDictWrapper;
import eu.europa.esig.dss.pdf.SingleDssDict;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDict;
import eu.europa.esig.dss.pdf.visible.ImageRotationUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfBoxDocumentReader
implements PdfDocumentReader {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxDocumentReader.class);
    private final PDDocument pdDocument;
    private DSSDocument dssDocument;
    private Map<PdfSignatureDictionary, List<PdfSignatureField>> signatureDictionaryMap;

    public PdfBoxDocumentReader(DSSDocument dssDocument) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        this(dssDocument, null);
    }

    public PdfBoxDocumentReader(DSSDocument dssDocument, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        Objects.requireNonNull(dssDocument, "The document must be defined!");
        this.dssDocument = dssDocument;
        try (InputStream is = dssDocument.openStream();){
            this.pdDocument = PDDocument.load((InputStream)is, (String)passwordProtection);
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(String.format("Encrypted document : %s", e.getMessage()));
        }
    }

    public PdfBoxDocumentReader(byte[] binaries, String passwordProtection) throws IOException, eu.europa.esig.dss.pades.exception.InvalidPasswordException {
        Objects.requireNonNull(binaries, "The document binaries must be defined!");
        this.dssDocument = new InMemoryDocument(binaries);
        try {
            this.pdDocument = PDDocument.load((byte[])binaries, (String)passwordProtection);
        }
        catch (InvalidPasswordException e) {
            throw new eu.europa.esig.dss.pades.exception.InvalidPasswordException(String.format("Encrypted document : %s", e.getMessage()));
        }
    }

    public PdfBoxDocumentReader(PDDocument pdDocument) {
        this.pdDocument = pdDocument;
    }

    public PDDocument getPDDocument() {
        return this.pdDocument;
    }

    public PdfDssDict getDSSDictionary() {
        PdfBoxDict catalog = new PdfBoxDict(this.pdDocument.getDocumentCatalog().getCOSObject(), this.pdDocument);
        return SingleDssDict.extract((PdfDict)catalog);
    }

    public Map<PdfSignatureDictionary, List<PdfSignatureField>> extractSigDictionaries() throws IOException {
        if (this.signatureDictionaryMap == null) {
            this.signatureDictionaryMap = new LinkedHashMap<PdfSignatureDictionary, List<PdfSignatureField>>();
            LinkedHashMap<Long, PdfSignatureDictionary> pdfObjectDictMap = new LinkedHashMap<Long, PdfSignatureDictionary>();
            List pdSignatureFields = this.pdDocument.getSignatureFields();
            if (Utils.isCollectionNotEmpty((Collection)pdSignatureFields)) {
                LOG.debug("{} signature(s) found", (Object)pdSignatureFields.size());
                for (PDSignatureField signatureField : pdSignatureFields) {
                    PdfBoxDict sigFieldDict = new PdfBoxDict(signatureField.getCOSObject(), this.pdDocument);
                    PdfSignatureField pdfSignatureField = new PdfSignatureField((PdfDict)sigFieldDict);
                    COSObject sigDictObject = signatureField.getCOSObject().getCOSObject(COSName.V);
                    if (sigDictObject == null || !(sigDictObject.getObject() instanceof COSDictionary)) {
                        LOG.warn("Signature field with name '{}' does not contain a signature", (Object)pdfSignatureField.getFieldName());
                        continue;
                    }
                    long sigDictNumber = sigDictObject.getObjectNumber();
                    PdfSignatureDictionary signature = (PdfSignatureDictionary)pdfObjectDictMap.get(sigDictNumber);
                    if (signature == null) {
                        try {
                            PdfBoxDict dictionary = new PdfBoxDict((COSDictionary)sigDictObject.getObject(), this.pdDocument);
                            signature = new PdfSigDictWrapper((PdfDict)dictionary);
                        }
                        catch (Exception e) {
                            LOG.warn("Unable to create a PdfSignatureDictionary for field with name '{}'", (Object)pdfSignatureField.getFieldName(), (Object)e);
                            continue;
                        }
                        ArrayList<PdfSignatureField> fields = new ArrayList<PdfSignatureField>();
                        fields.add(pdfSignatureField);
                        this.signatureDictionaryMap.put(signature, fields);
                        pdfObjectDictMap.put(sigDictNumber, signature);
                        continue;
                    }
                    List<PdfSignatureField> fieldList = this.signatureDictionaryMap.get(signature);
                    fieldList.add(pdfSignatureField);
                    LOG.warn("More than one field refers to the same signature dictionary: {}!", fieldList);
                }
            }
        }
        return this.signatureDictionaryMap;
    }

    public boolean isSignatureCoversWholeDocument(PdfSignatureDictionary signatureDictionary) {
        boolean bl;
        block8: {
            ByteRange byteRange = signatureDictionary.getByteRange();
            InputStream is = this.dssDocument.openStream();
            try {
                long originalBytesLength = Utils.getInputStreamSize((InputStream)is);
                long beforeSignatureLength = (long)byteRange.getFirstPartEnd() - (long)byteRange.getFirstPartStart();
                long expectedCMSLength = (long)byteRange.getSecondPartStart() - (long)byteRange.getFirstPartEnd() - (long)byteRange.getFirstPartStart();
                long afterSignatureLength = byteRange.getSecondPartEnd();
                long totalCoveredByByteRange = beforeSignatureLength + expectedCMSLength + afterSignatureLength;
                boolean bl2 = bl = originalBytesLength == totalCoveredByByteRange;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Cannot determine the original file size for the document. Reason : {}", (Object)e.getMessage());
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    public void close() throws IOException {
        this.pdDocument.close();
    }

    public int getNumberOfPages() {
        return this.pdDocument.getNumberOfPages();
    }

    public AnnotationBox getPageBox(int page) {
        PDPage pdPage = this.getPDPage(page);
        PDRectangle mediaBox = pdPage.getMediaBox();
        return new AnnotationBox(mediaBox.getLowerLeftX(), mediaBox.getLowerLeftY(), mediaBox.getUpperRightX(), mediaBox.getUpperRightY());
    }

    public int getPageRotation(int page) {
        PDPage pdPage = this.getPDPage(page);
        return pdPage.getRotation();
    }

    public List<PdfAnnotation> getPdfAnnotations(int page) throws IOException {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        List<PDAnnotation> pdAnnotations = this.getPageAnnotations(page);
        int pageRotation = this.getPageRotation(page);
        for (PDAnnotation pdAnnotation : pdAnnotations) {
            PdfAnnotation pdfAnnotation = this.toPdfAnnotation(pdAnnotation, pageRotation);
            if (pdfAnnotation == null) continue;
            annotations.add(pdfAnnotation);
        }
        return annotations;
    }

    private List<PDAnnotation> getPageAnnotations(int page) throws IOException {
        PDPage pdPage = this.getPDPage(page);
        return pdPage.getAnnotations();
    }

    public PDPage getPDPage(int page) {
        return this.pdDocument.getPage(page - 1);
    }

    private PdfAnnotation toPdfAnnotation(PDAnnotation pdAnnotation, int pageRotation) {
        PDRectangle pdRect = pdAnnotation.getRectangle();
        if (pdRect != null) {
            AnnotationBox annotationBox = new AnnotationBox(pdRect.getLowerLeftX(), pdRect.getLowerLeftY(), pdRect.getUpperRightX(), pdRect.getUpperRightY());
            if (pdAnnotation.isNoRotate()) {
                annotationBox = ImageRotationUtils.ensureNoRotate((AnnotationBox)annotationBox, (int)pageRotation);
            }
            PdfAnnotation pdfAnnotation = new PdfAnnotation(annotationBox);
            pdfAnnotation.setName(this.getSignatureFieldName(pdAnnotation));
            return pdfAnnotation;
        }
        return null;
    }

    private String getSignatureFieldName(PDAnnotation pdAnnotation) {
        return pdAnnotation.getCOSObject().getString(COSName.T);
    }

    public BufferedImage generateImageScreenshot(int page) throws IOException {
        PDFRenderer renderer = new PDFRenderer(this.pdDocument);
        return renderer.renderImage(page - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage generateImageScreenshotWithoutAnnotations(int page, List<PdfAnnotation> annotations) throws IOException {
        List<PDAnnotation> pdAnnotations = this.getPageAnnotations(page);
        int pageRotation = this.getPageRotation(page);
        pdAnnotations = this.getMatchingPDAnnotations(pdAnnotations, annotations, pageRotation);
        List<PDAnnotation> hiddenList = this.changeVisibility(pdAnnotations, true);
        try {
            BufferedImage bufferedImage = this.generateImageScreenshot(page);
            return bufferedImage;
        }
        finally {
            this.changeVisibility(hiddenList, false);
        }
    }

    private List<PDAnnotation> getMatchingPDAnnotations(List<PDAnnotation> pdAnnotations, List<PdfAnnotation> annotationsToExtract, int pageRotation) {
        ArrayList<PDAnnotation> result = new ArrayList<PDAnnotation>();
        for (PDAnnotation pdAnnotation : pdAnnotations) {
            PdfAnnotation pdfAnnotation = this.toPdfAnnotation(pdAnnotation, pageRotation);
            if (!annotationsToExtract.contains(pdfAnnotation)) continue;
            result.add(pdAnnotation);
        }
        return result;
    }

    private List<PDAnnotation> changeVisibility(List<PDAnnotation> pdAnnotations, boolean hide) {
        ArrayList<PDAnnotation> modifiedList = new ArrayList<PDAnnotation>();
        for (PDAnnotation pdAnnotation : pdAnnotations) {
            if (hide == pdAnnotation.isHidden()) continue;
            pdAnnotation.setHidden(hide);
            modifiedList.add(pdAnnotation);
        }
        return modifiedList;
    }

    public boolean isEncrypted() {
        return this.pdDocument.isEncrypted();
    }

    public boolean isOpenWithOwnerAccess() {
        AccessPermission accessPermission = this.getAccessPermission();
        return accessPermission.isOwnerPermission();
    }

    public boolean canFillSignatureForm() {
        AccessPermission accessPermission = this.getAccessPermission();
        return accessPermission.canModifyAnnotations() || accessPermission.canFillInForm();
    }

    public boolean canCreateSignatureField() {
        AccessPermission accessPermission = this.getAccessPermission();
        return accessPermission.canModify() && accessPermission.canModifyAnnotations();
    }

    private AccessPermission getAccessPermission() {
        return this.pdDocument.getCurrentAccessPermission();
    }

    public CertificationPermission getCertificationPermission() {
        COSDictionary signatureDict;
        COSDictionary permsDict;
        COSBase base;
        PDDocumentCatalog catalog = this.pdDocument.getDocumentCatalog();
        if (catalog != null && (base = catalog.getCOSObject().getDictionaryObject(COSName.PERMS)) instanceof COSDictionary && (base = (permsDict = (COSDictionary)base).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (base = (signatureDict = (COSDictionary)base).getDictionaryObject(COSName.REFERENCE)) instanceof COSArray) {
            COSArray refArray = (COSArray)base;
            for (int i = 0; i < refArray.size(); ++i) {
                CertificationPermission certificationPermission = this.getPermissionFromReference(refArray.getObject(i));
                if (certificationPermission == null) continue;
                return certificationPermission;
            }
        }
        return null;
    }

    private CertificationPermission getPermissionFromReference(COSBase reference) {
        COSBase transformParams;
        COSDictionary sigRefDict;
        if (reference instanceof COSDictionary && COSName.DOCMDP.equals((Object)(sigRefDict = (COSDictionary)reference).getDictionaryObject(COSName.TRANSFORM_METHOD)) && (transformParams = sigRefDict.getDictionaryObject(COSName.TRANSFORM_PARAMS)) instanceof COSDictionary) {
            COSDictionary transformDict = (COSDictionary)transformParams;
            int accessPermissions = transformDict.getInt(COSName.P, 2);
            if (accessPermissions < 1 || accessPermissions > 3) {
                accessPermissions = 2;
            }
            return CertificationPermission.fromCode((int)accessPermissions);
        }
        return null;
    }

    public boolean isUsageRightsSignaturePresent() {
        COSBase base;
        PDDocumentCatalog catalog = this.pdDocument.getDocumentCatalog();
        if (catalog != null && (base = catalog.getCOSObject().getDictionaryObject(COSName.PERMS)) instanceof COSDictionary) {
            COSDictionary permsDict = (COSDictionary)base;
            if ((base = permsDict.getDictionaryObject("UR")) != null) {
                return true;
            }
            base = permsDict.getDictionaryObject("UR3");
            if (base != null) {
                return true;
            }
        }
        return false;
    }

    public PdfDict getCatalogDictionary() {
        return new PdfBoxDict(this.pdDocument.getDocumentCatalog().getCOSObject(), this.pdDocument);
    }

    public long generateDocumentId(PAdESCommonParameters parameters) {
        String deterministicId = parameters.getDeterministicId();
        if (this.dssDocument != null && this.dssDocument.getName() != null) {
            deterministicId = deterministicId + "-" + this.dssDocument.getName();
        }
        long documentId = this.dssDocument != null ? DSSUtils.getFileByteSize((DSSDocument)this.dssDocument) : 0L;
        for (int i = 0; i < deterministicId.length(); ++i) {
            documentId += ((long)deterministicId.charAt(i) & 0xFFL) << 8 * i;
        }
        return documentId;
    }
}

