/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.SigningTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningTimeConverter
extends AbstractCMSSignPropertiesConverter<SigningTime> {
    private static final Logger LOG = LoggerFactory.getLogger(SigningTimeConverter.class);
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.pkcs_9_at_signingTime;

    public SigningTimeConverter() {
        super(ATTR_TYPE, SigningTime.class, true, ConstraintSignPolicy.EncodingConstraint.DEFAULT);
    }

    public Attribute encode(SigningTime signingTime, CMSSigningContext cache) {
        Date currentTime = new Date(System.currentTimeMillis());
        Date time = signingTime.getSigningTime().getTime();
        LOG.debug("SigningTime used: {} (current: {})", (Object)time, (Object)currentTime);
        return CMSAttributeHelper.createAttributeSigningTime(time);
    }

    public <T extends Attribute> SigningTime decode(T attribute) {
        ASN1Encodable value = attribute.getAttrValues().getObjectAt(0);
        GregorianCalendar gc = new GregorianCalendar();
        if (value instanceof ASN1GeneralizedTime) {
            try {
                gc.setTime(((ASN1GeneralizedTime)value).getDate());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (value instanceof ASN1UTCTime) {
            try {
                gc.setTime(((ASN1UTCTime)value).getDate());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new SigningTime((Calendar)gc, new ConstraintSignPolicy.EncodingConstraint[0]);
    }
}

