/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SigningCertificateConverter2
extends AbstractCMSSignPropertiesConverter<SigningCertificate> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_signingCertificateV2;
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_SIGNING_CERTIFICATE = ConstraintSignPolicy.EncodingConstraint.ETSI_EN;

    public SigningCertificateConverter2() {
        super(ATTR_TYPE, SigningCertificate.class, true, VERSION_SIGNING_CERTIFICATE);
    }

    public <T extends Attribute> SigningCertificate decode(T attribute) throws IOException {
        if (attribute == null || attribute.getAttributeValues().length == 0) {
            return null;
        }
        ArrayList<CertID> certIDs = new ArrayList<CertID>();
        for (ASN1Encodable attrValue : attribute.getAttributeValues()) {
            ESSCertIDv2 essCertID = ESSCertIDv2.getInstance((Object)attrValue);
            certIDs.add(new CertID(XMLOIDJCEAlgorithmMapper.getMapper().mapOIDAlgorithmXML(essCertID.getHashAlgorithm().getAlgorithm().getId()), essCertID.getCertHash(), new X500Principal(essCertID.getIssuerSerial().getIssuer().getEncoded()), essCertID.getIssuerSerial().getSerial().getValue()));
        }
        return new SigningCertificate(certIDs, false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_SIGNING_CERTIFICATE});
    }

    public Attribute encode(SigningCertificate signingCertificate, CMSSigningContext cache) throws IOException {
        if (signingCertificate == null) {
            return null;
        }
        ArrayList<ESSCertIDv2> certIDs = new ArrayList<ESSCertIDv2>();
        for (CertID certID : signingCertificate.getCertIDs()) {
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmOID(certID.getDigestAlgorithmURI())));
            certIDs.add(new ESSCertIDv2(digAlgId, certID.getDigest()));
        }
        return CMSAttributeHelper.createAttributeSigningCertificateV2(Collections.singletonList((ESSCertIDv2)certIDs.get(0)));
    }
}

