/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import java.io.IOException;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SigningCertificateConverter
extends AbstractCMSSignPropertiesConverter<SigningCertificate> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_signingCertificate;
    private static final ConstraintSignPolicy.EncodingConstraint VERSION_SIGNING_CERTIFICATE = ConstraintSignPolicy.EncodingConstraint.ETSI_TS;

    public SigningCertificateConverter() {
        super(ATTR_TYPE, SigningCertificate.class, false, VERSION_SIGNING_CERTIFICATE);
    }

    public <T extends Attribute> SigningCertificate decode(T attribute) throws IOException {
        if (attribute == null || attribute.getAttributeValues().length == 0) {
            return null;
        }
        ArrayList<CertID> certIDs = new ArrayList<CertID>();
        for (ASN1Encodable attrValue : attribute.getAttributeValues()) {
            ESSCertID essCertID = ESSCertID.getInstance((Object)attrValue);
            certIDs.add(new CertID("http://www.w3.org/2000/09/xmldsig#sha1", essCertID.getCertHash(), new X500Principal(essCertID.getIssuerSerial().getIssuer().getEncoded()), essCertID.getIssuerSerial().getSerial().getValue()));
        }
        return new SigningCertificate(certIDs, false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_SIGNING_CERTIFICATE});
    }

    public Attribute encode(SigningCertificate signingCertificate, CMSSigningContext cache) throws IOException {
        ASN1EncodableVector certIDs = new ASN1EncodableVector();
        for (CertID certID : signingCertificate.getCertIDs()) {
            if (!"SHA1".equals(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(certID.getDigestAlgorithmURI()))) {
                throw new IOException("SHA1 is required for using ESSCertID");
            }
            certIDs.add((ASN1Encodable)new ESSCertID(certID.getDigest()));
        }
        return CMSAttributeHelper.createAttributeSigningCertificateV1((ESSCertID)certIDs.get(0));
    }
}

