/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.cms.sign.props.CMSClaimedRole;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CertifiedRole;
import de.governikus.csl.uom.sign.props.ClaimedRole;
import de.governikus.csl.uom.sign.props.SignerRole;
import de.governikus.csl.uom.sign.props.XAdESEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class SignerRoleConverter
extends AbstractCMSSignPropertiesConverter<SignerRole> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_ets_signerAttr;
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_SIGNER_ROLE = ConstraintSignPolicy.EncodingConstraint.DEFAULT;

    public SignerRoleConverter() {
        super(ATTR_TYPE, SignerRole.class, true, VERSION_SIGNER_ROLE);
    }

    public <T extends org.bouncycastle.asn1.cms.Attribute> SignerRole decode(T attribute) throws IOException {
        if (attribute == null || attribute.getAttributeValues().length == 0) {
            return null;
        }
        ArrayList<CertifiedRole> certRoles = new ArrayList<CertifiedRole>();
        List claimedRoles = null;
        for (ASN1Encodable attrValue : attribute.getAttributeValues()) {
            SignerAttribute signerAttribute = SignerAttribute.getInstance((Object)attrValue);
            for (Object o : signerAttribute.getValues()) {
                try {
                    certRoles.add(new CertifiedRole(null, XAdESEncoding.DER.getEncodingURI(), AttributeCertificate.getInstance((Object)o).getEncoded()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new SignerRole(false, Arrays.asList(VERSION_SIGNER_ROLE.get(0)), claimedRoles, certRoles);
    }

    public org.bouncycastle.asn1.cms.Attribute encode(SignerRole signerRole, CMSSigningContext cache) throws IOException {
        SignerAttribute signerAttribute = null;
        if (signerRole.getClaimedRoles() != null && !signerRole.getClaimedRoles().isEmpty()) {
            ClaimedRole claimedRole = (ClaimedRole)signerRole.getClaimedRoles().get(0);
            if (!(claimedRole instanceof CMSClaimedRole)) {
                throw new IOException("encoding only supported for CMSClaimedRole");
            }
            CMSClaimedRole cmsClaimedRole = (CMSClaimedRole)claimedRole;
            List<String> claimedSignerRoles = cmsClaimedRole.getRoleNames();
            ArrayList<Attribute> claimedAttributes = new ArrayList<Attribute>(claimedSignerRoles.size());
            for (String claimedSignerRole : claimedSignerRoles) {
                DERUTF8String roles = new DERUTF8String(claimedSignerRole);
                Attribute id_aa_ets_signerAttr = new Attribute(X509ObjectIdentifiers.id_at_name, (ASN1Set)new DERSet((ASN1Encodable)roles));
                claimedAttributes.add(id_aa_ets_signerAttr);
            }
            return new org.bouncycastle.asn1.cms.Attribute(ATTR_TYPE, (ASN1Set)new DERSet((ASN1Encodable)new SignerAttribute(claimedAttributes.toArray(new Attribute[claimedAttributes.size()]))));
        }
        if (signerRole.getCertifiedRoles() != null) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(((CertifiedRole)signerRole.getCertifiedRoles().get(0)).getData());
            ASN1Sequence seq = null;
            try (ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);){
                seq = (ASN1Sequence)aIn.readObject();
            }
            signerAttribute = new SignerAttribute(AttributeCertificate.getInstance((Object)seq));
        }
        return CMSAttributeHelper.createAttributeSignerAttributes(signerAttribute);
    }
}

