/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.TimestampServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.SignatureTimestamp;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureTimestampCreator
extends AbstractCMSSignPropertiesConverter<SignatureTimestamp> {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureTimestampCreator.class);
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_SIGNATURE_TIMESTAMP = ConstraintSignPolicy.EncodingConstraint.DEFAULT;

    public SignatureTimestampCreator() {
        super(ATTR_TYPE, SignatureTimestamp.class, true, VERSION_SIGNATURE_TIMESTAMP);
    }

    public <T extends Attribute> SignatureTimestamp decode(T timestamp) throws IOException {
        ArrayList timestampTokens = new ArrayList();
        return new SignatureTimestamp(XMLOIDJCEAlgorithmMapper.getMapper().mapOIDAlgorithmXML(((TimeStampToken)timestampTokens.get(0)).getTimeStampInfo().getMessageImprintAlgOID().getId()), timestampTokens, true, VERSION_SIGNATURE_TIMESTAMP);
    }

    public Attribute encode(SignatureTimestamp signatureTimestamp, CMSSigningContext context) throws IOException {
        LOG.debug("signature timestamp creation start: {}", (Object)new Date(System.currentTimeMillis()));
        TimestampServiceResource tspServiceResource = null;
        if (signatureTimestamp.getTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)signatureTimestamp.getTimestampService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService();
        } else {
            throw new IOException("failed to create Timestamp, TSP resource not available or missing");
        }
        byte[] signatureValue = (byte[])context.unsignedAttrParameters.get("encryptedDigest");
        byte[] tspDigestValue = null;
        try {
            MessageDigest md = CryptoProviderUtil.getMessageDigestInstance((String)XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(signatureTimestamp.getDigestAlgorithmURI()));
            tspDigestValue = md.digest(signatureValue);
        }
        catch (Exception e) {
            throw new IOException("calculating digest failed: " + e.getMessage(), e);
        }
        TimeStampToken timeStamp = tspServiceResource.getTimeStamp(signatureTimestamp.getDigestAlgorithmURI(), tspDigestValue);
        context.signatureTimeStampTokens.add(timeStamp);
        LOG.debug("signature timestamp creation end: {}", (Object)new Date(System.currentTimeMillis()));
        return CMSAttributeHelper.createSignatureTimestampAttribute(timeStamp.getEncoded());
    }
}

