/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.SigPolicyHash;
import de.governikus.csl.uom.sign.props.SignaturePolicyId;
import de.governikus.csl.uom.sign.props.SignaturePolicyIdentifier;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignaturePolicyIdentifierConverter
extends AbstractCMSSignPropertiesConverter<SignaturePolicyIdentifier> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_ets_sigPolicyId;
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_SIGNER_ROLE = ConstraintSignPolicy.EncodingConstraint.DEFAULT;

    public SignaturePolicyIdentifierConverter() {
        super(ATTR_TYPE, SignaturePolicyIdentifier.class, true, VERSION_SIGNER_ROLE);
    }

    public <T extends Attribute> SignaturePolicyIdentifier decode(T attribute) throws IOException {
        return null;
    }

    public Attribute encode(SignaturePolicyIdentifier signaturePolicyIdentifier, CMSSigningContext cache) throws IOException {
        SignaturePolicyId id = signaturePolicyIdentifier.getId();
        SigPolicyHash sigPolicyHash = id.getSigPolicyHash();
        AlgorithmIdentifier hashAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmOID(sigPolicyHash.getDigestAlgorithmURI())));
        OtherHashAlgAndValue sigPolicyHashValue = new OtherHashAlgAndValue(hashAlgorithm, (ASN1OctetString)new DEROctetString(sigPolicyHash.getDigestValue()));
        org.bouncycastle.asn1.esf.SignaturePolicyId signaturePolicyId = new org.bouncycastle.asn1.esf.SignaturePolicyId(new ASN1ObjectIdentifier((String)id.getPolicyId().getAny()), sigPolicyHashValue);
        return CMSAttributeHelper.createAttributeSignaturePolicyIdentifier(signaturePolicyId);
    }
}

