/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.uom.res.CertificateValidationServiceResource;
import de.governikus.csl.uom.res.TrustedAnchorServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.RevocationValues;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValuesAdder
extends AbstractCMSSignPropertiesConverter<RevocationValues>
implements SelfProcessingSignPropertiesEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationValuesAdder.class);
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_ets_revocationValues;
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_REVOCATION_VALUES = ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    private final Attribute processed = new Attribute(ATTR_TYPE, (ASN1Set)new DERSet());

    public RevocationValuesAdder() {
        super(ATTR_TYPE, RevocationValues.class, true, VERSION_REVOCATION_VALUES);
    }

    public <T extends Attribute> RevocationValues decode(T revocationValues) throws IOException {
        ArrayList ocspResps = new ArrayList();
        ArrayList cRLs = new ArrayList();
        return new RevocationValues(ocspResps, cRLs, true, VERSION_REVOCATION_VALUES);
    }

    public Attribute encode(RevocationValues revocationValues, CMSSigningContext context) throws IOException {
        TrustedAnchorServiceResource trustedAnchorService = null;
        if (revocationValues.getTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)revocationValues.getTrustedAnchorService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService();
        } else {
            throw new IOException("Trusted anchor resource not available or missing");
        }
        CertificateValidationServiceResource certificateValidationService = null;
        if (revocationValues.getCertificateValidationService() != null) {
            certificateValidationService = (CertificateValidationServiceResource)revocationValues.getCertificateValidationService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService() != null) {
            certificateValidationService = (CertificateValidationServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService();
        } else {
            throw new IOException("CVS resource not available or missing");
        }
        Certificate[] signerCertificates = trustedAnchorService.getCertificateChain((Certificate)context.signerCert);
        if (signerCertificates != null && signerCertificates.length > 0) {
            LOG.debug("signerCertificates: " + signerCertificates.length);
            this.addRevocationValues(revocationValues, certificateValidationService, context, Arrays.asList(signerCertificates));
        }
        return this.processed;
    }

    private void addRevocationValues(RevocationValues revocationValues, CertificateValidationServiceResource certificateValidationService, CMSSigningContext cache, Collection<?> certificates) throws IOException {
        if (certificates != null && !certificates.isEmpty()) {
            OCSPResp[] ocspResps;
            ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
            for (Object certificate : certificates) {
                try {
                    if (certificate instanceof X509CertificateHolder) {
                        X509CertificateHolder c = (X509CertificateHolder)certificate;
                        x509Certificates.add(new JcaX509CertificateConverter().getCertificate(c));
                        continue;
                    }
                    if (!(certificate instanceof X509Certificate)) continue;
                    x509Certificates.add((X509Certificate)certificate);
                }
                catch (Exception e) {
                    throw new IOException("creating certificates for ValidationData failed: " + e.getMessage(), e);
                }
            }
            if (revocationValues.areOCSPResponsesUsed() && (ocspResps = certificateValidationService.getOcspResponses(null, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && ocspResps.length != 0) {
                for (OCSPResp ocspResp : ocspResps) {
                    cache.addOCSP(ocspResp);
                }
            }
            if (revocationValues.areCRLsUsed()) {
                CRL[] crls = certificateValidationService.getCRLs(null, (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]));
                cache.addCRLs(crls);
            }
        }
    }

    public Object getProcessedReturnNullInstance() {
        return this.processed;
    }
}

