/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.ProductionPlace;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.DirectoryString;

public class ProductionPlaceConverter
extends AbstractCMSSignPropertiesConverter<ProductionPlace> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_ets_signerLocation;
    private static final int IDX_POSTAL_ADDRESS_POSTAL_CODE = 0;
    private static final int IDX_POSTAL_ADDRESS_CITY = 1;
    private static final int IDX_POSTAL_ADDRESS_STREET = 2;

    public ProductionPlaceConverter() {
        super(ATTR_TYPE, ProductionPlace.class, true, ConstraintSignPolicy.EncodingConstraint.DEFAULT);
    }

    public Attribute encode(ProductionPlace productionPlace, CMSSigningContext cache) {
        String countryName = null;
        String stateOrProvince = null;
        ASN1Sequence postalAddress = null;
        if (productionPlace != null) {
            countryName = productionPlace.getCountryName();
            stateOrProvince = productionPlace.getStateOrProvince();
            ArrayList<String> postalParts = new ArrayList<String>();
            postalParts.add(productionPlace.getPostalCode());
            postalParts.add(productionPlace.getCity());
            postalParts.add(productionPlace.getStreetAddress());
            postalAddress = ProductionPlaceConverter.toPostalAddress(postalParts);
        }
        return CMSAttributeHelper.createAttributeSignerLocation(new SignerLocation((ASN1UTF8String)new DERUTF8String(countryName), (ASN1UTF8String)new DERUTF8String(stateOrProvince), postalAddress));
    }

    public static ASN1Sequence toPostalAddress(List<String> postalAddressParts) {
        if (postalAddressParts == null) {
            return null;
        }
        postalAddressParts.remove(null);
        if (postalAddressParts.isEmpty()) {
            return null;
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (String postalAddressPart : postalAddressParts) {
            v.add((ASN1Encodable)new DERUTF8String(postalAddressPart));
        }
        return new DERSequence(v);
    }

    public <T extends Attribute> ProductionPlace decode(T attribute) {
        if (attribute == null || attribute.getAttributeValues().length == 0) {
            return null;
        }
        SignerLocation signerLocation = SignerLocation.getInstance((Object)attribute.getAttributeValues()[0]);
        String city = null;
        String countryName = null;
        String postalCode = null;
        String stateOrProvince = null;
        String street = null;
        if (signerLocation != null) {
            ASN1Sequence postalAddress = signerLocation.getPostalAddress();
            city = this.getString(postalAddress, 1);
            countryName = signerLocation.getCountryName().getString();
            postalCode = this.getString(postalAddress, 0);
            stateOrProvince = signerLocation.getLocalityName().getString();
            street = this.getString(postalAddress, 2);
        }
        return new ProductionPlace(city, countryName, postalCode, stateOrProvince, street);
    }

    private String getString(ASN1Sequence postalAddress, int idx) {
        if (postalAddress == null) {
            return null;
        }
        if (postalAddress.size() < idx) {
            return null;
        }
        return DirectoryString.getInstance((Object)postalAddress.getObjectAt(idx)).getString();
    }
}

