/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.CertificateValidationServiceResource;
import de.governikus.csl.uom.res.TimestampServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.ContentTimestamp;
import java.io.IOException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTimestampCreator
extends AbstractCMSSignPropertiesConverter<ContentTimestamp> {
    private static final Logger LOG = LoggerFactory.getLogger(ContentTimestampCreator.class);
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_ets_contentTimestamp;
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_CONTENT_TIMESTAMP = ConstraintSignPolicy.EncodingConstraint.DEFAULT;

    public ContentTimestampCreator() {
        super(ATTR_TYPE, ContentTimestamp.class, true, VERSION_CONTENT_TIMESTAMP);
    }

    public <T extends Attribute> ContentTimestamp decode(T attribute) throws IOException {
        return null;
    }

    public Attribute encode(ContentTimestamp contentTimestamp, CMSSigningContext context) throws IOException {
        Collection certificates;
        LOG.debug("content timestamp creation start: {}", (Object)new Date(System.currentTimeMillis()));
        TimestampServiceResource tspServiceResource = null;
        if (contentTimestamp.getTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)contentTimestamp.getTimestampService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService() != null) {
            tspServiceResource = (TimestampServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTimestampService();
        } else {
            throw new IOException("failed to create Timestamp, TSP resource not available or missing");
        }
        byte[] messageDigest = (byte[])context.signedAttrParameters.get("digest");
        String signatureDigestAlgorithmURI = XMLOIDJCEAlgorithmMapper.getMapper().mapOIDAlgorithmXML(((AlgorithmIdentifier)context.signedAttrParameters.get("digestAlgID")).getAlgorithm().getId());
        if (!signatureDigestAlgorithmURI.equals(contentTimestamp.getDigestAlgorithmURI())) {
            throw new IOException("content timestamp can not be created, only same digest algorithm as signature algorithm related digest algorithm supported");
        }
        TimeStampToken timeStamp = tspServiceResource.getTimeStamp(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(contentTimestamp.getDigestAlgorithmURI()), messageDigest);
        if (contentTimestamp.isValidationDataUsed() && (certificates = timeStamp.getCertificates().getMatches(null)) != null && !certificates.isEmpty()) {
            ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
            for (Object certificate : certificates) {
                if (certificate instanceof X509CertificateHolder) {
                    try {
                        x509Certificates.add(new JcaX509CertificateConverter().setProvider("BC").getCertificate((X509CertificateHolder)certificate));
                    }
                    catch (CertificateException certificateException) {}
                    continue;
                }
                if (!(certificate instanceof X509Certificate)) continue;
                x509Certificates.add((X509Certificate)certificate);
            }
            if (contentTimestamp.areOCSPResponsesUsed() || contentTimestamp.areCRLsUsed()) {
                CRL[] crls;
                CertificateValidationServiceResource cvs = null;
                if (contentTimestamp.getCertificateValidationService() != null) {
                    cvs = (CertificateValidationServiceResource)contentTimestamp.getCertificateValidationService();
                } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService() != null) {
                    cvs = (CertificateValidationServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultCertificateValidationService();
                } else {
                    throw new IOException("CVS resource not available or missing");
                }
                if (contentTimestamp.areOCSPResponsesUsed()) {
                    OCSPResp[] ocspResps = cvs.getOcspResponses(null, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]));
                    context.addOCSPs(ocspResps);
                }
                if (contentTimestamp.areCRLsUsed() && (crls = cvs.getCRLs(null, (Certificate[])x509Certificates.toArray(new X509Certificate[x509Certificates.size()]))) != null && crls.length != 0) {
                    context.addCRLs(crls);
                }
            }
        }
        LOG.debug("content timestamp creation ends: {}", (Object)new Date(System.currentTimeMillis()));
        return CMSAttributeHelper.createContentTimestampAttribute(timeStamp.getEncoded());
    }
}

