/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.cms.sign.props.CommitmentTypeIndicationAttribute;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.props.CommitmentQualifier;
import de.governikus.csl.uom.sign.props.CommitmentTypeIndication;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class CommitmentTypeConverter
extends AbstractCMSSignPropertiesConverter<CommitmentTypeIndication> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_signingCertificate;
    private static final List<ConstraintSignPolicy.EncodingConstraint> VERSION_COMMITMENT_TYPE_INDICATION = ConstraintSignPolicy.EncodingConstraint.DEFAULT;

    public CommitmentTypeConverter() {
        super(ATTR_TYPE, CommitmentTypeIndication.class, true, VERSION_COMMITMENT_TYPE_INDICATION);
    }

    public <T extends Attribute> CommitmentTypeIndication decode(T attribute) throws IOException {
        if (attribute == null || attribute.getAttributeValues().length == 0) {
            return null;
        }
        ArrayList<CommitmentQualifier> qualifiers = new ArrayList<CommitmentQualifier>();
        CommitmentTypeIndicationAttribute ctia = new CommitmentTypeIndicationAttribute(attribute);
        for (ASN1Encodable value : ctia.getAttributeValues()) {
            qualifiers.add(new CommitmentQualifier(ASN1ObjectIdentifier.getInstance((Object)value).getId()));
        }
        return new CommitmentTypeIndication(null, qualifiers, false, new ConstraintSignPolicy.EncodingConstraint[]{VERSION_COMMITMENT_TYPE_INDICATION.get(0)});
    }

    public Attribute encode(CommitmentTypeIndication commitmentTypeIndication, CMSSigningContext cache) throws IOException {
        ArrayList<ASN1ObjectIdentifier> qualifiers = new ArrayList<ASN1ObjectIdentifier>();
        for (CommitmentQualifier qualifier : commitmentTypeIndication.getQualifiers()) {
            qualifiers.add(new ASN1ObjectIdentifier((String)qualifier.getAny()));
        }
        return CMSAttributeHelper.createAttributeCommitmentTypeIndication(qualifiers.toArray(new ASN1ObjectIdentifier[qualifiers.size()]));
    }
}

