/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.uom.res.TrustedAnchorServiceResource;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.props.CertificateValues;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValuesAdder
extends AbstractCMSSignPropertiesConverter<CertificateValues>
implements SelfProcessingSignPropertiesEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateValuesAdder.class);
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.id_aa_ets_certValues;
    private static final List<ConstraintSignPolicy.EncodingConstraint> ENCODING_CERTIFICATE_VALUES = ConstraintSignPolicy.EncodingConstraint.ETSI_EN_TS;
    private final Attribute processed = new Attribute(ATTR_TYPE, (ASN1Set)new DERSet());

    public CertificateValuesAdder() {
        super(ATTR_TYPE, CertificateValues.class, true, ENCODING_CERTIFICATE_VALUES);
    }

    public <T extends Attribute> CertificateValues decode(T certificateValues) throws IOException {
        ArrayList certificates = new ArrayList();
        return new CertificateValues(certificates, true, ENCODING_CERTIFICATE_VALUES);
    }

    public Attribute encode(CertificateValues certificateValues, CMSSigningContext context) throws IOException {
        TrustedAnchorServiceResource trustedAnchorService = null;
        if (certificateValues.getTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)certificateValues.getTrustedAnchorService();
        } else if (((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService() != null) {
            trustedAnchorService = (TrustedAnchorServiceResource)((SignOptions)context.getSignRequest().getOptions()).getDefaultTrustedAnchorService();
        } else {
            throw new IOException("Trusted anchor resource not available or missing");
        }
        Certificate[] signerCertificates = trustedAnchorService.getCertificateChain((Certificate)context.signerCert);
        if (signerCertificates != null && signerCertificates.length > 0) {
            LOG.debug("signerCertificates: " + signerCertificates.length);
            this.addCertificates(context, Arrays.asList(signerCertificates));
        }
        if (!context.signatureTimeStampTokens.isEmpty()) {
            for (TimeStampToken signatureTimeStampToken : context.signatureTimeStampTokens) {
                Collection certificates = signatureTimeStampToken.getCertificates().getMatches(null);
                LOG.debug("timestamp Certificates: " + certificates.size());
                if (certificates == null || certificates.isEmpty()) continue;
                context.addCertificates(certificates);
            }
        }
        LOG.debug("complete Certificates: " + context.certs.size());
        return this.processed;
    }

    private void addCertificates(CMSSigningContext cache, Collection<?> certificates) throws IOException {
        for (Object certificate : certificates) {
            if (certificate instanceof X509CertificateHolder) {
                cache.addCertificate((X509CertificateHolder)certificate);
                continue;
            }
            if (!(certificate instanceof X509Certificate)) continue;
            cache.addCertificate((X509Certificate)certificate);
        }
    }

    public Object getProcessedReturnNullInstance() {
        return this.processed;
    }
}

