/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.CMSContentTypeConverter;
import de.governikus.csl.cms.sign.props.CMSFriendlyNameConverter;
import de.governikus.csl.cms.sign.props.CertificateValuesAdder;
import de.governikus.csl.cms.sign.props.CommitmentTypeConverter;
import de.governikus.csl.cms.sign.props.ContentTimestampCreator;
import de.governikus.csl.cms.sign.props.ProductionPlaceConverter;
import de.governikus.csl.cms.sign.props.RevocationValuesAdder;
import de.governikus.csl.cms.sign.props.SignaturePolicyIdentifierConverter;
import de.governikus.csl.cms.sign.props.SignatureTimestampCreator;
import de.governikus.csl.cms.sign.props.SignerRoleConverter;
import de.governikus.csl.cms.sign.props.SigningCertificateConverter;
import de.governikus.csl.cms.sign.props.SigningCertificateConverter2;
import de.governikus.csl.cms.sign.props.SigningTimeConverter;
import de.governikus.csl.sign.props.AbstractSignPropertiesConverterManager;
import de.governikus.csl.sign.props.ConverterEncodingDivider;
import de.governikus.csl.sign.props.SignPropertiesConverter;
import de.governikus.csl.uom.sign.SignProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.cms.Attribute;

public class CMSSignPropertiesConverterManager
extends AbstractSignPropertiesConverterManager<Attribute, CMSSigningContext> {
    public static final List<SignPropertiesConverter<? extends SignProperty, ? extends Attribute, CMSSigningContext>> LIST_CONVERTERS = Collections.unmodifiableList(Arrays.asList(new SignPropertiesConverter[]{new SigningCertificateConverter(), new ProductionPlaceConverter(), new SigningCertificateConverter2(), new SignerRoleConverter(), new CommitmentTypeConverter(), new ContentTimestampCreator(), new SignaturePolicyIdentifierConverter(), new SignatureTimestampCreator(), new CertificateValuesAdder(), new RevocationValuesAdder(), new CMSContentTypeConverter(), new SigningTimeConverter(), new CMSFriendlyNameConverter()}));
    private static CMSSignPropertiesConverterManager manager;

    private CMSSignPropertiesConverterManager() {
        super(Attribute.class, CMSSigningContext.class);
        for (SignPropertiesConverter<? extends SignProperty, ? extends Attribute, CMSSigningContext> converter : LIST_CONVERTERS) {
            if (converter instanceof ConverterEncodingDivider) continue;
            throw new IllegalArgumentException("converter must implement ConverterEncodingDivider interface");
        }
        super.add(LIST_CONVERTERS);
    }

    public static CMSSignPropertiesConverterManager getManager() {
        if (manager == null) {
            manager = new CMSSignPropertiesConverterManager();
        }
        return manager;
    }

    public <T extends Attribute, S extends SignProperty> S decode(Class<S> typeClass, T encodedProperty) throws IOException {
        throw new UnsupportedOperationException();
    }

    public <T extends Attribute> SignProperty decode(T encodedProperty) throws IOException {
        if (encodedProperty == null) {
            return null;
        }
        String divider = CMSSignPropertiesConverterManager.createVersionSuffix((String)encodedProperty.getAttrType().getId());
        SignPropertiesConverter adESPropertiesConverter = (SignPropertiesConverter)this.decoderMap.get(encodedProperty.getClass().getName() + divider);
        if (adESPropertiesConverter == null) {
            throw new RuntimeException("decoding converter not available: " + encodedProperty);
        }
        if (adESPropertiesConverter.getEncodedClass().isInstance(encodedProperty)) {
            return adESPropertiesConverter.decode(encodedProperty);
        }
        return null;
    }
}

