/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.cms.sign.props.CMSFriendlyName;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class CMSFriendlyNameConverter
extends AbstractCMSSignPropertiesConverter<CMSFriendlyName> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.pkcs_9_at_signingTime;
    private static final List<ConstraintSignPolicy.EncodingConstraint> DEFAULT_VERSIONS = ConstraintSignPolicy.EncodingConstraint.DEFAULT;

    public CMSFriendlyNameConverter() {
        super(ATTR_TYPE, CMSFriendlyName.class, true, DEFAULT_VERSIONS);
    }

    public Attribute encode(CMSFriendlyName friendlyName, CMSSigningContext cache) {
        return CMSAttributeHelper.createAttributeFriendlyName(friendlyName.getFriendlyName());
    }

    public <T extends Attribute> CMSFriendlyName decode(T attribute) {
        ASN1Encodable value = attribute.getAttrValues().getObjectAt(0);
        if (value instanceof ASN1String) {
            return new CMSFriendlyName(((ASN1String)value).getString(), true, DEFAULT_VERSIONS);
        }
        return null;
    }
}

