/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.props.AbstractCMSSignPropertiesConverter;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.cms.sign.props.CMSContentType;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class CMSContentTypeConverter
extends AbstractCMSSignPropertiesConverter<CMSContentType> {
    private static final ASN1ObjectIdentifier ATTR_TYPE = PKCSObjectIdentifiers.pkcs_9_at_contentType;

    public CMSContentTypeConverter() {
        super(ATTR_TYPE, CMSContentType.class, true, ConstraintSignPolicy.EncodingConstraint.ETSI_TS_EN);
    }

    public Attribute encode(CMSContentType contentType, CMSSigningContext cache) {
        return CMSAttributeHelper.createAttributeContentType(contentType.getContentType());
    }

    public <T extends Attribute> CMSContentType decode(T attribute) {
        ASN1Encodable value = attribute.getAttrValues().getObjectAt(0);
        if (value instanceof ASN1ObjectIdentifier) {
            return new CMSContentType(((ASN1ObjectIdentifier)value).getId(), new ConstraintSignPolicy.EncodingConstraint[0]);
        }
        return null;
    }
}

