/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.governikus.csl.cms.sign.props.ASN1Helper;
import de.governikus.csl.cms.sign.props.CommitmentTypeIndicationAttribute;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;

public final class CMSAttributeHelper {
    public static final String SIMPLE_DATE_FORMAT_ASN1TIME_YYYY_MM_DD_HH_MM_SS_SSS = "yyyyMMddHHmmss.SSS";
    public static final String SIMPLE_DATE_FORMAT_YYYY_MM_DD = "yyyyMMdd";
    public static final String CMS_DATE_GENERALIZED_TIME_TO_STRING = "19491231";
    static final Date CMS_DATE_GENERALIZED_TIME_TO;
    public static final String CMS_DATE_GENERALIZED_TIME_FROM_STRING = "20500101";
    static final Date CMS_DATE_GENERALIZED_TIME_FROM;
    public static final String CMS_DATE_UTC_TIME_TO_STRING = "20491231";
    static final Date CMS_DATE_UTC_TIME_TO;
    public static final String CMS_DATE_UTC_TIME_FROM_STRING = "19500101";
    static final Date CMS_DATE_UTC_TIME_FROM;
    public static final String DEFAULT_ROVIDER_NAME = "BC";

    public static Attribute createAttribute(ASN1ObjectIdentifier attributeIdentifier, ASN1Encodable attributeValue) {
        return new Attribute(attributeIdentifier, (ASN1Set)new DERSet(attributeValue));
    }

    public static Attribute createAttribute(String attributeOID, byte[] attributeValueBytes) throws IOException {
        return CMSAttributeHelper.createAttribute(attributeOID, (ASN1Encodable)DERSet.getInstance((Object)attributeValueBytes));
    }

    public static Attribute createAttribute(String attributeOID, ASN1Encodable attributeValue) {
        return CMSAttributeHelper.createAttribute(new ASN1ObjectIdentifier(attributeOID), attributeValue);
    }

    public static Attribute createAttributeCommitmentTypeIndication(ASN1ObjectIdentifier ... commitTypeQualifierIdentifiers) throws IOException {
        return new CommitmentTypeIndicationAttribute(commitTypeQualifierIdentifiers);
    }

    public static Attribute createAttributeContentHints(ContentHints contentHints) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_contentHint, (ASN1Encodable)contentHints);
    }

    public static Attribute createAttributeContentHints(ASN1ObjectIdentifier contentType, String contentDescription) {
        return CMSAttributeHelper.createAttributeContentHints(new ContentHints(contentType, contentDescription == null || contentDescription.isEmpty() ? null : new DERUTF8String(contentDescription)));
    }

    public static Attribute createAttributeContentIdentifier(byte[] contentIdentifier) {
        return CMSAttributeHelper.createAttributeContentIdentifier(new ContentIdentifier(contentIdentifier));
    }

    public static Attribute createAttributeContentIdentifier(ContentIdentifier contentIdentifier) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_contentIdentifier, (ASN1Encodable)contentIdentifier);
    }

    public static Attribute createAttributeContentIdentifier(String contentIdentifier) {
        try {
            return CMSAttributeHelper.createAttributeContentIdentifier(new ContentIdentifier(contentIdentifier.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("failed to get content identifier bytes as UTF-8: " + e.getMessage(), e);
        }
    }

    public static Attribute createAttributeContentReference(ASN1ObjectIdentifier contentType, byte[] contentIdentifier, byte[] originatorSignatureValue) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_contentReference, (ASN1Encodable)ASN1Helper.toSequence(new ASN1Encodable[]{contentType, new DEROctetString(contentIdentifier), originatorSignatureValue != null && originatorSignatureValue.length > 0 ? new DEROctetString(originatorSignatureValue) : null}));
    }

    public static Attribute createAttributeContentType(ASN1ObjectIdentifier contentType) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.pkcs_9_at_contentType, (ASN1Encodable)contentType);
    }

    public static Attribute createAttributeContentType(String contentTypeOID) {
        return CMSAttributeHelper.createAttributeContentType(new ASN1ObjectIdentifier(contentTypeOID));
    }

    public static Attribute createAttributeFriendlyName(String friendlyName) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (ASN1Encodable)new DERBMPString(friendlyName));
    }

    public static Attribute createAttributeMessageDigest(byte[] digestValue) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest, (ASN1Encodable)new DEROctetString(digestValue));
    }

    public static Attribute createAttributeMessageDigest(MessageDigest messageDigest) {
        return CMSAttributeHelper.createAttributeMessageDigest(messageDigest.digest());
    }

    public static Attribute createAttributeSignaturePolicyIdentifier(ASN1ObjectIdentifier sigPolicyId, OtherHashAlgAndValue sigPolicyHash, SigPolicyQualifiers sigPolicyQualifiers) {
        return CMSAttributeHelper.createAttributeSignaturePolicyIdentifier(new SignaturePolicyId(sigPolicyId, sigPolicyHash, sigPolicyQualifiers));
    }

    public static Attribute createAttributeSignaturePolicyIdentifier(SignaturePolicyId signaturePolicyId) {
        return CMSAttributeHelper.createAttributeSignaturePolicyIdentifier(new SignaturePolicyIdentifier(signaturePolicyId));
    }

    public static Attribute createAttributeSignaturePolicyIdentifier(SignaturePolicyIdentifier signaturePolicyIdentifier) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, (ASN1Encodable)signaturePolicyIdentifier);
    }

    public static Attribute createAttributeSignerAttributes(SignerAttribute signerAttribute) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, (ASN1Encodable)signerAttribute);
    }

    public static Attribute createAttributeSignerLocation(SignerLocation signerLocation) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, (ASN1Encodable)signerLocation);
    }

    public static Attribute createAttributeSigningCertificate(AlgorithmIdentifier[] digestAlgorithms, ContentInfo contentInfo, Certificate[] certificates, CRL[] crls, SignerInfo[] signerInformations) throws CertificateEncodingException, IOException {
        DERSet lDigestAlgorithms = digestAlgorithms != null && digestAlgorithms.length > 0 ? new DERSet((ASN1Encodable[])digestAlgorithms) : null;
        ASN1EncodableVector listCertificates = null;
        if (certificates != null && certificates.length > 0) {
            listCertificates = new ASN1EncodableVector();
            for (Certificate certificate : certificates) {
                listCertificates.add((ASN1Encodable)new X509CertificateHolder(certificate.getEncoded()).toASN1Structure());
            }
        }
        DERSet lCertificates = listCertificates != null && listCertificates.size() > 0 ? new DERSet(listCertificates) : null;
        ASN1EncodableVector listCrls = null;
        if (certificates != null && certificates.length > 0) {
            listCertificates = new ASN1EncodableVector();
            for (Certificate certificate : certificates) {
                listCertificates.add((ASN1Encodable)new X509CertificateHolder(certificate.getEncoded()).toASN1Structure());
            }
        }
        DERSet lCrls = listCrls != null && listCrls.size() > 0 ? new DERSet(listCrls) : null;
        DERSet signerInfos = signerInformations != null && signerInformations.length > 0 ? new DERSet((ASN1Encodable[])signerInformations) : null;
        SignedData signedData = new SignedData((ASN1Set)lDigestAlgorithms, contentInfo, (ASN1Set)lCertificates, (ASN1Set)lCrls, (ASN1Set)signerInfos);
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
    }

    public static Attribute createAttributeSigningCertificateV1(Certificate ... certificates) throws CertificateEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        ArrayList<ESSCertID> essCertIDs = new ArrayList<ESSCertID>();
        for (Certificate certificate : certificates) {
            essCertIDs.add(new ESSCertID(ASN1Helper.calculateDigest(OIWObjectIdentifiers.idSHA1, certificate.getEncoded())));
        }
        return CMSAttributeHelper.createAttributeSigningCertificateV1((ESSCertID)essCertIDs.get(0));
    }

    public static Attribute createAttributeSigningCertificateV1(ESSCertID essCertID) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Encodable)new SigningCertificate(CMSAttributeHelper.checkNoIssuerSerial(essCertID)));
    }

    public static ESSCertID checkNoIssuerSerial(ESSCertID essCertID) {
        if (essCertID == null) {
            throw new IllegalArgumentException("null is invalid as ESSCertID");
        }
        if (essCertID.getIssuerSerial() != null) {
            throw new IllegalArgumentException("IssuerSerial should not be used anymore");
        }
        return essCertID;
    }

    public static Attribute createAttributeSigningCertificateV2(AlgorithmIdentifier digestAlgorithmIdentifier, Certificate ... certificates) throws CertificateEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        ArrayList<ESSCertIDv2> listESSCertIDv2s = new ArrayList<ESSCertIDv2>();
        for (Certificate certificate : certificates) {
            listESSCertIDv2s.add(new ESSCertIDv2(digestAlgorithmIdentifier, ASN1Helper.calculateDigest(digestAlgorithmIdentifier, certificate.getEncoded())));
        }
        return CMSAttributeHelper.createAttributeSigningCertificateV2(listESSCertIDv2s);
    }

    public static Attribute createAttributeSigningCertificateV2(List<ESSCertIDv2> certIDs) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Encodable)new SigningCertificateV2(CMSAttributeHelper.checkNoIssuerSerial(certIDs).toArray(new ESSCertIDv2[certIDs.size()])));
    }

    public static List<ESSCertIDv2> checkNoIssuerSerial(List<ESSCertIDv2> certIDs) {
        if (certIDs == null || certIDs.isEmpty()) {
            throw new IllegalArgumentException("null or empty list of ESSCertIDv2 are invalid");
        }
        for (ESSCertIDv2 certID : certIDs) {
            if (certID == null) {
                throw new IllegalArgumentException("null is invalid as ESSCertIDv2");
            }
            if (certID.getIssuerSerial() == null) continue;
            throw new IllegalArgumentException("IssuerSerial should not be used anymore");
        }
        return certIDs;
    }

    public static Attribute createAttributeSigningCertificateV2(ASN1ObjectIdentifier digestAlgorithmIdentifier, Certificate ... certificates) throws CertificateEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        return CMSAttributeHelper.createAttributeSigningCertificateV2(new AlgorithmIdentifier(digestAlgorithmIdentifier), certificates);
    }

    public static Attribute createAttributeSigningCertificateV2(String digestAlgorithmOID, Certificate ... certificates) throws CertificateEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        return CMSAttributeHelper.createAttributeSigningCertificateV2(new ASN1ObjectIdentifier(digestAlgorithmOID), certificates);
    }

    public static Attribute createAttributeSigningTime() {
        return CMSAttributeHelper.createAttributeSigningTime(System.currentTimeMillis());
    }

    public static Attribute createAttributeSigningTime(Date signingDate) {
        return CMSAttributeHelper.createAttribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, CMSAttributeHelper.createASN1SigningTimeValue(signingDate));
    }

    public static ASN1Encodable createASN1SigningTimeValue(Date signingDate) {
        return CMSAttributeHelper.useUTCTime(signingDate) ? CMSAttributeHelper.createUTCTime(0, signingDate, null) : CMSAttributeHelper.createGeneralizedTime(0, signingDate, null);
    }

    private static ASN1UTCTime createUTCTime(int resolution, Date time, Locale locale) {
        return new ASN1UTCTime(time, locale == null ? Locale.getDefault() : locale);
    }

    private static boolean useUTCTime(Date signingDate) {
        return CMS_DATE_GENERALIZED_TIME_TO.before(signingDate) && CMS_DATE_GENERALIZED_TIME_FROM.after(signingDate);
    }

    private static ASN1GeneralizedTime createGeneralizedTime(int resolution, Date time, Locale locale) {
        String format = SIMPLE_DATE_FORMAT_ASN1TIME_YYYY_MM_DD_HH_MM_SS_SSS;
        SimpleDateFormat dateF = locale == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, locale);
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        StringBuilder sBuild = new StringBuilder(dateF.format(time));
        int dotIndex = sBuild.indexOf(".");
        if (dotIndex < 0) {
            sBuild.append("Z");
            return new ASN1GeneralizedTime(sBuild.toString());
        }
        switch (resolution) {
            case 1: {
                if (sBuild.length() <= dotIndex + 2) break;
                sBuild.delete(dotIndex + 2, sBuild.length());
                break;
            }
            case 2: {
                if (sBuild.length() <= dotIndex + 3) break;
                sBuild.delete(dotIndex + 3, sBuild.length());
                break;
            }
            case 3: {
                break;
            }
            default: {
                return new ASN1GeneralizedTime(time);
            }
        }
        while (sBuild.charAt(sBuild.length() - 1) == '0') {
            sBuild.deleteCharAt(sBuild.length() - 1);
        }
        if (sBuild.length() - 1 == dotIndex) {
            sBuild.deleteCharAt(sBuild.length() - 1);
        }
        sBuild.append("Z");
        return new ASN1GeneralizedTime(sBuild.toString());
    }

    public static Attribute createAttributeSigningTime(long signingTime) {
        return CMSAttributeHelper.createAttributeSigningTime(new Date(signingTime));
    }

    public static Attribute createContentTimestampAttribute(byte[] timeStampTokenBytes) throws IOException {
        return CMSAttributeHelper.createTimestampAttribute(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, timeStampTokenBytes);
    }

    public static Attribute createSignatureTimestampAttribute(byte[] timeStampTokenBytes) throws IOException {
        return CMSAttributeHelper.createTimestampAttribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, timeStampTokenBytes);
    }

    public static Attribute createTimestampAttribute(ASN1ObjectIdentifier timeStampIdentifier, byte[] timeStampTokenBytes) throws IOException {
        return CMSAttributeHelper.createAttribute(timeStampIdentifier, (ASN1Encodable)ASN1Sequence.fromByteArray((byte[])timeStampTokenBytes));
    }

    private CMSAttributeHelper() {
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat(SIMPLE_DATE_FORMAT_YYYY_MM_DD);
        try {
            Date d;
            CMS_DATE_GENERALIZED_TIME_TO = d = sdf.parse(CMS_DATE_GENERALIZED_TIME_TO_STRING);
            CMS_DATE_UTC_TIME_FROM = d = sdf.parse(CMS_DATE_UTC_TIME_FROM_STRING);
            CMS_DATE_UTC_TIME_TO = d = sdf.parse(CMS_DATE_UTC_TIME_TO_STRING);
            CMS_DATE_GENERALIZED_TIME_FROM = d = sdf.parse(CMS_DATE_GENERALIZED_TIME_FROM_STRING);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

