/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.props;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class ASN1Helper {
    public static final String SHA2_JCA_NAME_LENGTH_SEPARATOR = "-";
    public static final String DEFAULT_ROVIDER_NAME = "BC";

    private ASN1Helper() {
    }

    public static byte[] calculateDigest(AlgorithmIdentifier digestAlgorithmIdentifier, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException {
        return ASN1Helper.calculateDigest(digestAlgorithmIdentifier.getAlgorithm(), data);
    }

    public static byte[] calculateDigest(ASN1ObjectIdentifier digestAlgorithmIdentifier, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException {
        return ASN1Helper.calculateDigest(digestAlgorithmIdentifier.getId(), data);
    }

    public static byte[] calculateDigest(String digestAlgorithm, byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest messageDigest = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm);
        return messageDigest.digest(data);
    }

    public static AlgorithmIdentifier getDigestAlgorithmIdentifier(String digestAlgorithmName) {
        DigestAlgorithm digestAlgorithm = AlgorithmService.getDigestForJCAName((String)digestAlgorithmName);
        if (digestAlgorithm == null) {
            digestAlgorithm = AlgorithmService.getDigestForName((String)digestAlgorithmName);
        }
        return ASN1Helper.getAlgorithmIdentifier((Algorithm)digestAlgorithm);
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(Algorithm algorithm) {
        return ASN1Helper.getAlgorithmIdentifier(algorithm, false);
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(Algorithm algorithm, boolean withNull) {
        if (withNull) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(algorithm.getOID()), (ASN1Encodable)ASN1Null.getInstance((Object)new byte[]{5, 0}));
        }
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(algorithm.getOID()));
    }

    public static DigestAlgorithm getDigestAlgorithm(AlgorithmIdentifier digestAlgorithmIdentifier) {
        return ASN1Helper.getDigestAlgorithm(digestAlgorithmIdentifier.getAlgorithm());
    }

    public static DigestAlgorithm getDigestAlgorithm(ASN1ObjectIdentifier digestAlgorithmObjectIdentifier) {
        return AlgorithmService.getDigestForOID((String)digestAlgorithmObjectIdentifier.getId());
    }

    public static String getDigestAlgorithmJcaName(String digestAlgorithm) {
        DigestAlgorithm tmpDigestAlgorithm = AlgorithmService.getDigestForJCAName((String)digestAlgorithm);
        if (tmpDigestAlgorithm != null) {
            return digestAlgorithm;
        }
        tmpDigestAlgorithm = AlgorithmService.getDigestForOID((String)digestAlgorithm);
        String digestJCAName = tmpDigestAlgorithm.getJCAName();
        if (digestJCAName.contains(SHA2_JCA_NAME_LENGTH_SEPARATOR)) {
            digestJCAName = digestJCAName.replaceAll(SHA2_JCA_NAME_LENGTH_SEPARATOR, "");
        }
        return digestJCAName;
    }

    public static DERSequence toSequence(ASN1Encodable ... asn1encodables) {
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        if (asn1encodables != null && asn1encodables.length > 0) {
            for (ASN1Encodable asn1encodable : asn1encodables) {
                if (asn1encodable == null) continue;
                asn1EncodableVector.add(asn1encodable);
            }
        }
        return ASN1Helper.toSequence(asn1EncodableVector);
    }

    public static DERSequence toSequence(ASN1EncodableVector asn1EncodableVector) {
        return new DERSequence(asn1EncodableVector);
    }

    public static DERSet toSequenceSet(ASN1Encodable ... asn1encodables) {
        ASN1EncodableVector result = new ASN1EncodableVector();
        if (asn1encodables != null) {
            for (ASN1Encodable asn1encodable : asn1encodables) {
                if (asn1encodable == null) continue;
                result.add((ASN1Encodable)ASN1Helper.toSequence(asn1encodable));
            }
        }
        return new DERSet(result);
    }

    public static DERSet toSet(ASN1Encodable ... asn1encodables) {
        ASN1EncodableVector asn1EncodableVector = new ASN1EncodableVector();
        if (asn1encodables != null) {
            for (ASN1Encodable asn1encodable : asn1encodables) {
                if (asn1encodable == null) continue;
                asn1EncodableVector.add(asn1encodable);
            }
        }
        return ASN1Helper.toSet(asn1EncodableVector);
    }

    public static DERSet toSet(ASN1EncodableVector asn1EncodableVector) {
        return new DERSet(asn1EncodableVector);
    }
}

