/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.impl;

import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.util.SimpleDataHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.activation.DataHandler;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class CMSUtils {
    public static final Selector<Object> SELECTOR_ALL = CMSUtils.newSelector(Object.class);
    public static final Selector<ASN1Encodable> SELECTOR_ASN1ENCODABLE_ALL = CMSUtils.newSelector(ASN1Encodable.class);
    public static final Selector<X509AttributeCertificateHolder> SELECTOR_X509ATTRIBUTECERTIFICATEHOLDER_ALL = CMSUtils.newSelector(X509AttributeCertificateHolder.class);
    public static final Selector<X509CertificateHolder> SELECTOR_X509CERTIFICATEHOLDER_ALL = CMSUtils.newSelector(X509CertificateHolder.class);
    public static final Selector<X509CRLHolder> SELECTOR_X509CRLHOLDER_ALL = CMSUtils.newSelector(X509CRLHolder.class);

    public static final <T> Selector<T> newSelector(Class<T> type) {
        return new Selector<T>(){

            public Selector<T> clone() {
                return this;
            }

            public boolean match(T obj) {
                return true;
            }
        };
    }

    CMSUtils() {
    }

    public CMSSignedData checkCMSSignedData(Object parsed) throws CSLSignatureException {
        if (!(parsed instanceof CMSSignedData)) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "content document and provided detached signature are not related: " + (parsed == null ? null : parsed.getClass().getName()));
        }
        return (CMSSignedData)parsed;
    }

    public void checkDetached(CMSSignedData cms) throws CSLSignatureException {
        if (!cms.isDetachedSignature()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "provided cms signature does not represent a detached signature");
        }
    }

    public void checkSignerInfos(SignRequest signRequest) throws CSLSignatureException {
        Set signerInfos = ((SignOptions)signRequest.getOptions()).getSignerInfos();
        if (signerInfos == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "no signer specified at request");
        }
        if (signerInfos.size() != 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only one signer info is supported currently");
        }
    }

    public CMSSignedData createMergedSignature(CMSSignedData oneCMSSignature, CMSSignedData anotherCMSSignature) throws CSLSignatureException {
        try {
            SignerInformationStore mergedSignerInformationStore = this.mergeSignerInformations(oneCMSSignature, anotherCMSSignature);
            JcaCertStore mergedCertificates = this.mergeCertificates(oneCMSSignature, anotherCMSSignature);
            JcaCertStore mergedAttrCerts = this.mergeAttributeCertificates(oneCMSSignature, anotherCMSSignature);
            Store<?> mergedRevocations = this.mergeRevocations(oneCMSSignature, anotherCMSSignature);
            CMSSignedData result = CMSSignedData.replaceSigners((CMSSignedData)oneCMSSignature, (SignerInformationStore)mergedSignerInformationStore);
            return CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)result, (Store)mergedCertificates, (Store)mergedAttrCerts, mergedRevocations);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to merge an old and new cms signature: " + e.getMessage(), (Throwable)e);
        }
    }

    public DataHandler createMergedSignatureHandler(CMSSignedData oneCMSSignature, CMSSignedData anotherCMSSignature) throws CSLSignatureException {
        try {
            CMSSignedData result = this.createMergedSignature(oneCMSSignature, anotherCMSSignature);
            return new SimpleDataHandler((InputStream)new ByteArrayInputStream(result.getEncoded()), "application/pkcs7-signature");
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to created encoded bytes of merged cms signature: " + e.getMessage(), (Throwable)e);
        }
    }

    public Collection<Object> getOthersFromStore(ASN1ObjectIdentifier otherRevocationInfoFormat, Store otherRevocationInfos) throws CSLSignatureException {
        ArrayList<Object> others = new ArrayList<Object>();
        Iterator it = otherRevocationInfos.getMatches(SELECTOR_ALL).iterator();
        while (it.hasNext()) {
            OtherRevocationInfoFormat infoFormat = new OtherRevocationInfoFormat(otherRevocationInfoFormat, (ASN1Encodable)it.next());
            this.validateInfoFormat(infoFormat);
            others.add(new DERTaggedObject(false, 1, (ASN1Encodable)infoFormat));
        }
        return others;
    }

    private JcaCertStore mergeAttributeCertificates(CMSSignedData oneCMSSignature, CMSSignedData anotherCMSSignature) throws CertificateEncodingException {
        Store oneAttributeCertificateStore = oneCMSSignature.getAttributeCertificates();
        Store anotherAttributeCertificateStore = anotherCMSSignature.getAttributeCertificates();
        ArrayList mergedAttributeCertificates = new ArrayList();
        mergedAttributeCertificates.addAll(oneAttributeCertificateStore.getMatches(SELECTOR_X509ATTRIBUTECERTIFICATEHOLDER_ALL));
        mergedAttributeCertificates.addAll(anotherAttributeCertificateStore.getMatches(SELECTOR_X509ATTRIBUTECERTIFICATEHOLDER_ALL));
        return new JcaCertStore(mergedAttributeCertificates);
    }

    private JcaCertStore mergeCertificates(CMSSignedData oneCMSSignature, CMSSignedData anotherCMSSignature) throws CertificateEncodingException {
        Store oldCertificateStore = oneCMSSignature.getCertificates();
        Store newCertificateStore = anotherCMSSignature.getCertificates();
        ArrayList certificates = new ArrayList();
        certificates.addAll(oldCertificateStore.getMatches(SELECTOR_X509CERTIFICATEHOLDER_ALL));
        certificates.addAll(newCertificateStore.getMatches(SELECTOR_X509CERTIFICATEHOLDER_ALL));
        return new JcaCertStore(certificates);
    }

    private Store<?> mergeRevocations(CMSSignedData oneCMSSignature, CMSSignedData anotherCMSSignature) {
        Store oneCRLs = oneCMSSignature.getCRLs();
        Store anotherCRLs = anotherCMSSignature.getCRLs();
        Store oneOtherRevocationInfo = oneCMSSignature.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        Store anotherOtherRevocationInfo = anotherCMSSignature.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        ArrayList mergedRevocations = new ArrayList();
        mergedRevocations.addAll(oneCRLs.getMatches(SELECTOR_X509CRLHOLDER_ALL));
        mergedRevocations.addAll(anotherCRLs.getMatches(SELECTOR_X509CRLHOLDER_ALL));
        mergedRevocations.addAll(oneOtherRevocationInfo.getMatches(SELECTOR_ALL));
        mergedRevocations.addAll(anotherOtherRevocationInfo.getMatches(SELECTOR_ALL));
        return new CollectionStore(mergedRevocations);
    }

    private SignerInformationStore mergeSignerInformations(CMSSignedData oneCMSSignature, CMSSignedData anotherCMSSignature) {
        SignerInformationStore oneSignerInformationStore = oneCMSSignature.getSignerInfos();
        SignerInformationStore anotherSignerInformationStore = anotherCMSSignature.getSignerInfos();
        ArrayList mergedSignerInformations = new ArrayList();
        mergedSignerInformations.addAll(oneSignerInformationStore.getSigners());
        mergedSignerInformations.addAll(anotherSignerInformationStore.getSigners());
        return new SignerInformationStore(mergedSignerInformations);
    }

    public void validateInfoFormat(OtherRevocationInfoFormat infoFormat) throws CSLSignatureException {
        OCSPResponse resp;
        if (CMSObjectIdentifiers.id_ri_ocsp_response.equals((ASN1Primitive)infoFormat.getInfoFormat()) && (resp = OCSPResponse.getInstance((Object)infoFormat.getInfo())).getResponseStatus().getValue().intValue() != 0) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "cannot add unsuccessful OCSP response to CMS SignedData");
        }
    }
}

