/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.impl;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.impl.CMSAttributeTable;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SigningContext;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.sign.UnsignedProperty;
import de.governikus.csl.uom.sign.props.SinglePropertyAttribute;
import java.io.IOException;
import java.util.Map;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSUnsignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CMSUnsignedAttributeTableGenerator.class);
    private final CMSSigningContext cache;
    private final UnsignedProperties unsignedProperties;

    public CMSUnsignedAttributeTableGenerator(UnsignedProperties unsignedProperties, CMSSigningContext cache) {
        this.unsignedProperties = unsignedProperties;
        this.cache = cache;
    }

    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
        if (this.unsignedProperties.isEmpty()) {
            LOG.debug("no unsigned properties to encode");
        } else {
            this.cache.unsignedAttrTable = new CMSAttributeTable();
            this.cache.unsignedAttrParameters = parameters;
            LOG.debug("encoding unsigned properties");
            for (UnsignedProperty unsignedProperty : this.unsignedProperties) {
                try {
                    Attribute attribute = (Attribute)this.cache.adesPropsConverter.encode((SignProperty)unsignedProperty, (SigningContext)this.cache);
                    if (attribute != null) {
                        if (unsignedProperty instanceof SinglePropertyAttribute && this.cache.signedAttrTable.get(attribute.getAttrType()) != null) {
                            LOG.debug("unsigned attribute indicated to present only once, but already present - removing present attribute");
                            this.cache.unsignedAttrTable = this.cache.unsignedAttrTable.remove(attribute.getAttrType());
                        }
                        LOG.debug("adding to unsigned attribute table");
                        this.cache.unsignedAttrTable.addAttribute(attribute);
                        continue;
                    }
                    LOG.debug("no attribute encoded (added by converter)");
                }
                catch (IOException e) {
                    throw new CMSAttributeTableGenerationException("failed to create additional AdES table unsigned attributes: " + e.getMessage(), (Exception)e);
                }
            }
            if (this.cache.unsignedAttrTable.size() == 0) {
                return null;
            }
        }
        LOG.debug("encoding unsigned properties finished");
        return this.cache.unsignedAttrTable.toAttributeTable();
    }
}

