/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.impl;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.impl.CMSAttributeTable;
import de.governikus.csl.cms.sign.props.CMSAttributeHelper;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignedProperty;
import de.governikus.csl.uom.sign.SigningContext;
import de.governikus.csl.uom.sign.props.CertID;
import de.governikus.csl.uom.sign.props.NoSigningTime;
import de.governikus.csl.uom.sign.props.SigningCertificate;
import de.governikus.csl.uom.sign.props.SigningTime;
import de.governikus.csl.uom.sign.props.SinglePropertyAttribute;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSSignedAttributeTableGenerator
extends DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CMSSignedAttributeTableGenerator.class);
    private final CMSSigningContext cache;
    private final SignedProperties signedProperties;

    public CMSSignedAttributeTableGenerator(SignedProperties signedProperties, CMSSigningContext cache) {
        this.signedProperties = signedProperties;
        this.cache = cache;
    }

    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
        this.cache.signedAttrTable = new CMSAttributeTable(this.createStandardAttributeTable(parameters));
        this.cache.signedAttrParameters = parameters;
        boolean noSigningTime = false;
        SigningTime signingTime = null;
        if (this.signedProperties.isEmpty()) {
            LOG.debug("no additional signed properties to encode - default properties are used only");
        } else {
            LOG.debug("encoding signed properties");
            for (SignedProperty signedProperty : this.signedProperties) {
                SigningCertificate sc;
                if (signedProperty instanceof SigningCertificate && ((sc = (SigningCertificate)signedProperty).getCertIDs() == null || sc.getCertIDs().isEmpty())) {
                    sc.setCertIDs(Arrays.asList(new CertID(this.cache.algoIdDigest, this.cache.signerCert)));
                }
                try {
                    if (signedProperty instanceof SigningTime) {
                        signingTime = (SigningTime)signedProperty;
                        continue;
                    }
                    if (signedProperty instanceof NoSigningTime) {
                        noSigningTime = true;
                        continue;
                    }
                    Attribute attribute = (Attribute)this.cache.adesPropsConverter.encode((SignProperty)signedProperty, (SigningContext)this.cache);
                    if (attribute != null) {
                        if (signedProperty instanceof SinglePropertyAttribute && this.cache.signedAttrTable.get(attribute.getAttrType()) != null) {
                            LOG.debug("signed attribute indicated to present only once, but already present - removing present attribute");
                            this.cache.signedAttrTable = this.cache.signedAttrTable.remove(attribute.getAttrType());
                        }
                        LOG.debug("adding to signed attribute table");
                        this.cache.signedAttrTable.addAttribute(attribute);
                        continue;
                    }
                    LOG.debug("no attribute encoded (added by converter)");
                }
                catch (IOException e) {
                    throw new CMSAttributeTableGenerationException("failed to create additional AdES table signed attributes: " + e.getMessage(), (Exception)e);
                }
            }
        }
        LOG.debug("encoding signed properties finished");
        if (noSigningTime) {
            this.cache.signedAttrTable = this.cache.signedAttrTable.remove(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        } else if (signingTime != null) {
            Attribute attribute = null;
            try {
                attribute = (Attribute)this.cache.adesPropsConverter.encode((SignProperty)signingTime, (SigningContext)this.cache);
            }
            catch (IOException e) {
                throw new CMSAttributeTableGenerationException("failed to create additional AdES table signed attributes: " + e.getMessage(), (Exception)e);
            }
            this.cache.signedAttrTable = this.cache.signedAttrTable.remove(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
            this.cache.signedAttrTable.addAttribute(attribute);
        }
        if (this.cache.externalDigest != null) {
            this.cache.signedAttrTable = this.cache.signedAttrTable.remove(CMSAttributes.messageDigest);
            this.cache.signedAttrTable.addAttribute(CMSAttributeHelper.createAttribute(CMSAttributes.messageDigest, (ASN1Encodable)new DEROctetString(this.cache.externalDigest)));
        }
        return this.cache.signedAttrTable.toAttributeTable();
    }
}

