/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.impl;

import de.governikus.csl.cms.sign.CMSSigningContext;
import de.governikus.csl.cms.sign.doc.CMSSignedDocument;
import de.governikus.csl.cms.sign.doc.impl.CMSSignedDocumentImpl;
import de.governikus.csl.cms.sign.doc.impl.CMSSimpleParser;
import de.governikus.csl.cms.sign.impl.CMSRequestUtils;
import de.governikus.csl.cms.sign.impl.CMSSignedAttributeTableGenerator;
import de.governikus.csl.cms.sign.impl.CMSUnsignedAttributeTableGenerator;
import de.governikus.csl.cms.sign.impl.CMSUtils;
import de.governikus.csl.cms.sign.props.CMSContentType;
import de.governikus.csl.cms.sign.props.CMSSignPropertiesConverterManager;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.DetachedSignedDocumentWithContentDocument;
import de.governikus.csl.sign.SignedDocument;
import de.governikus.csl.sign.doc.DigestDocument;
import de.governikus.csl.sign.impl.AbstractSignPlugin;
import de.governikus.csl.sign.impl.DetachedSignedDocumentWithContentDocumentImpl;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.core.SignedDataResponseImpl;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.jce.CSLCryptoProvider;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.AbstractKeyResource;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPlugin;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignatureType;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.ades.AdESSignCreationPolicy;
import de.governikus.csl.uom.sign.impl.CounterSignerInfo;
import de.governikus.csl.uom.sign.impl.PreRequestCheckerRegistry;
import de.governikus.csl.uom.sign.props.NoSigningTime;
import de.governikus.csl.uom.sign.props.PropertiesUtil;
import de.governikus.csl.uom.sign.props.SigningTime;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.uom.util.SimpleDataHandler;
import de.governikus.csl.uom.util.SwapFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.activation.DataHandler;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginType(id=Plugin.PluginID.SIGN_CMS, type=SignPlugin.class)
public class CMSSignPluginImpl
extends AbstractSignPlugin {
    static List<Class<? extends Document>> DOCUMENT_OUTPUT_CLASSES = Collections.unmodifiableList(Arrays.asList(CMSSignedDocument.class));
    private static final Logger LOG = LoggerFactory.getLogger(CMSSignPluginImpl.class);
    private final CMSRequestUtils cmsRequestUtils;
    private final CMSUtils cmsUtils;
    private CMSSignPropertiesConverterManager adesPropsConverter = CMSSignPropertiesConverterManager.getManager();

    public CMSSignPluginImpl(CMSUtils cmsUtils, CMSRequestUtils cmsRequestUtils) throws CSLSignatureException {
        super(DOCUMENT_OUTPUT_CLASSES);
        this.cmsUtils = Objects.requireNonNull(cmsUtils, "CMSUtils are required");
        this.cmsRequestUtils = Objects.requireNonNull(cmsRequestUtils, "CMSRequestUtils are required");
        if (Security.getProvider("CPP") == null) {
            Security.addProvider((Provider)new CSLCryptoProvider());
        }
    }

    public CMSSignPluginImpl() throws CSLSignatureException {
        this(new CMSUtils(), new CMSRequestUtils());
    }

    public SignedDataResponse sign(SignRequest signRequest, Environment env) throws CoreException {
        LOG.debug("entering CMS/CAdES sign ...");
        SignOptions options = null;
        AdESSignCreationPolicy adesPolicy = null;
        boolean allCounterSignerInfo = false;
        try {
            LOG.debug("CMS/CAdES sign preparing ...");
            CMSSignPluginImpl.checkSignRequest((SignRequest)signRequest);
            options = (SignOptions)signRequest.getOptions();
            adesPolicy = AdESSignCreationPolicy.getPolicy((SignPolicy)((SignPolicy)options.getPolicy()));
            allCounterSignerInfo = CMSSignPluginImpl.allCounterSignerInfo((SignOptions)options);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "prepare failed with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (allCounterSignerInfo) {
                LOG.debug("CMS/CAdES counter signature requested");
                SignedDataResponse e = this.signCounter(signRequest, env);
                return e;
            }
            if (adesPolicy != null || options.getPolicy() != null) {
                LOG.debug("CMS/CAdES standard signature requested");
                SignedDataResponse e = this.signCMSSimpleAndMerge(signRequest, env, adesPolicy);
                return e;
            }
            try {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "Policy not supported");
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with not expected exception: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            LOG.debug("leaving CMS/CAdES sign");
        }
    }

    private SignedDataResponse signCMSSimpleAndMerge(SignRequest signRequest, Environment env, AdESSignCreationPolicy adesPolicy) throws CoreException {
        String type = adesPolicy == null ? "CMS" : "CAdES";
        CMSSigningContext context = this.prepareSignature(type, signRequest, env);
        context.type = type;
        CMSSignedData oldCMSSignature = this.setupOldCMSSignature(context, signRequest);
        SignedDataResponse response = this.signCMSSimple(context, adesPolicy, signRequest, env);
        if (oldCMSSignature != null) {
            SignedData signedData = (SignedData)response.getDatas().get(0);
            return this.createSignResponseData(context.contentDocument, this.cmsUtils.createMergedSignatureHandler(oldCMSSignature, ((CMSSignedDocumentImpl)signedData.getSignature()).getParsed()));
        }
        return response;
    }

    private CMSSignedData setupOldCMSSignature(CMSSigningContext context, SignRequest signRequest) throws CoreException {
        if (SignatureType.DETACHED != ((SignOptions)signRequest.getOptions()).getSignatureType()) {
            return null;
        }
        if (context.contentDocument instanceof DetachedSignedDocumentWithContentDocument) {
            DetachedSignedDocumentWithContentDocument documentPair = (DetachedSignedDocumentWithContentDocument)context.contentDocument;
            try {
                Document contentDocument = documentPair.getContentDocument();
                if (contentDocument != null) {
                    CMSSignedData cms = this.cmsUtils.checkCMSSignedData(documentPair.getParsed());
                    this.cmsUtils.checkDetached(cms);
                    this.cmsRequestUtils.checkDigestAlgorithmURI((SignedDocument<?>)documentPair);
                    this.cmsUtils.checkSignerInfos(signRequest);
                    DetachedSignedDocumentWithContentDocumentImpl.checkDocumentPair((SignedDocument)documentPair, (Document)contentDocument);
                    context.contentDocument = contentDocument;
                    return cms;
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "content document and provided detached signature are not related", (Throwable)e);
            }
        }
        return null;
    }

    private InputStream generatorSign(CMSSigningContext context) throws CSLSignatureException {
        InputStream inputStream;
        block23: {
            ASN1ObjectIdentifier eContentType = CMSObjectIdentifiers.data;
            List foundContentTypes = PropertiesUtil.findSignedProperties(CMSContentType.class, (SignedProperties)context.signedProperties);
            if (foundContentTypes != null && !foundContentTypes.isEmpty() && foundContentTypes.get(0) != null) {
                eContentType = new ASN1ObjectIdentifier(((CMSContentType)((Object)foundContentTypes.get(0))).getContentType());
            }
            ByteArrayOutputStream os = context.contentDocument instanceof DigestDocument ? new ByteArrayOutputStream() : new SwapFileOutputStream(context.tempFile, 524288);
            ByteArrayOutputStream buffer = os;
            try {
                try (OutputStream streamToBeSigned = context.gen.open(eContentType, (OutputStream)buffer, context.enveloped);
                     InputStream is = context.contentDocument.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)streamToBeSigned);
                    IOUtils.closeQuietly((InputStream)is);
                }
                LOG.debug("CMS/CAdES signature created");
                InputStream result = os instanceof ByteArrayOutputStream ? new ByteArrayInputStream(os.toByteArray()) : ((SwapFileOutputStream)buffer).getInputStream();
                inputStream = result;
                if (buffer == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (buffer != null) {
                        try {
                            ((OutputStream)buffer).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with BC: " + e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign with BC with not expected exception: " + e.getMessage(), (Throwable)e);
                }
            }
            ((OutputStream)buffer).close();
        }
        return inputStream;
    }

    /*
     * Loose catch block
     */
    private SignedDataResponse signCMSSimple(CMSSigningContext context, AdESSignCreationPolicy adesPolicy, SignRequest signRequest, Environment env) throws CoreException {
        try {
            LOG.debug("{} sign processing ...", (Object)context.type);
            InputStream storeBuffer = null;
            try {
                storeBuffer = this.generatorSign(context);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign " + context.type + " with not expected Exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                LOG.debug("{} sign finished", (Object)context.type);
            }
            try {
                LOG.debug("response preparing ...");
                SimpleDataHandler simpleDataHandler = new SimpleDataHandler(storeBuffer, "application/pkcs7-signature");
                SignedDataResponse signedDataResponse = this.createSignResponseData(context.contentDocument, (DataHandler)simpleDataHandler);
                return signedDataResponse;
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign " + context.type + " at returning response with not expected Exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                LOG.debug("response prepared");
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LOG.debug("{} signature created", (Object)context.type);
        }
    }

    public SignedDataResponse createSignResponseData(Document contentDocument, DataHandler simpleDataHandler) {
        SimpleSignedData signedData = new SimpleSignedData(Collections.singletonList(contentDocument), (Document)new CMSSignedDocumentImpl(simpleDataHandler));
        ArrayList<SimpleSignedData> datas = new ArrayList<SimpleSignedData>();
        datas.add(signedData);
        return new SignedDataResponseImpl(datas);
    }

    private CMSSigningContext prepareSignature(String type, SignRequest signRequest, Environment env) throws CoreException {
        CMSSigningContext context = null;
        try {
            LOG.debug("{} check signature request", (Object)type);
            SignedProperties signedProperties = ((SignerInfo)((SignOptions)signRequest.getOptions()).getSignerInfos().iterator().next()).getSignedProperties();
            if (!PropertiesUtil.existsSignedProperties(SigningTime.class, (SignedProperties)signedProperties) && !PropertiesUtil.existsSignedProperties(NoSigningTime.class, (SignedProperties)signedProperties)) {
                signedProperties.add((Object)new SigningTime(new ConstraintSignPolicy.EncodingConstraint[0]));
            }
            PreRequestCheckerRegistry.getRegistry().check(signRequest);
            LOG.debug("prepare {} signing ...", (Object)type);
            context = this.createContext(signRequest, env);
            context.gen = new CMSSignedDataStreamGenerator();
            ContentSigner contentSigner = this.createContentSigner(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(context.algoIdSignature), (AbstractKeyResource<?>)context.privateKeyResource);
            JcaDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
            JcaSignerInfoGeneratorBuilder signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(digestCalculatorProviderBuilder.build());
            signerInfoGenerator.setSignedAttributeGenerator((CMSAttributeTableGenerator)new CMSSignedAttributeTableGenerator(context.signerInfo.getSignedProperties(), context));
            if (!context.signerInfo.getUnsignedProperties().isEmpty()) {
                signerInfoGenerator.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)new CMSUnsignedAttributeTableGenerator(context.signerInfo.getUnsignedProperties(), context));
            }
            context.gen.addSignerInfoGenerator(signerInfoGenerator.build(contentSigner, context.signerCert));
            for (Certificate c : context.signerCertChain) {
                X509CertificateHolder x509 = new X509CertificateHolder(c.getEncoded());
                if (context.certs.contains(x509)) continue;
                context.certs.add(x509);
            }
            context.gen.addCertificates((Store)new JcaCertStore(context.certs));
            context.gen.addAttributeCertificates((Store)new JcaCertStore(context.attrCerts));
            context.gen.addAttributeCertificates((Store)new JcaCertStore(context.crls));
            context.enveloped = context.getSignOptions().getSignatureType() == SignatureType.ENVELOPED;
            LOG.debug("signing {}...", (Object)type);
            context.contentDocument = this.cmsRequestUtils.getContentDocument(signRequest);
            if (SignatureType.DETACHED != context.signOptions.getSignatureType() && context.contentDocument instanceof DigestDocument) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with external digest, only detached supported: " + context.signOptions.getSignatureType());
            }
            if (context.contentDocument instanceof DigestDocument) {
                DigestDocument externalDigestDocument = (DigestDocument)context.contentDocument;
                if (!externalDigestDocument.getDigestAlgorithmURI().equals(context.algoIdDigest)) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with external digest algorithm failure: request " + context.algoIdDigest + " digest algorithm does not match external digest algorithm " + externalDigestDocument.getDigestAlgorithmURI());
                }
                context.externalDigest = ((DigestDocument)context.contentDocument).getDigestValue();
                context.tempFile = null;
            } else {
                context.tempFile = env != null ? env.getTempDataManager().createTempFile("cmsdata", "tmp") : File.createTempFile("cms", "withoutTmpManager");
            }
            Object object = context;
            return object;
        }
        catch (CSLSignatureException e) {
            throw e;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with io failure: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with certificate: " + e.getMessage(), (Throwable)e);
        }
        catch (CMSException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign at " + type + ": " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare " + type + " with not expected Exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            LOG.debug("CMS/CAdES sign prepared");
        }
    }

    private CMSSigningContext createContext(SignRequest signRequest, Environment env) throws CoreException {
        LOG.debug("creating context...");
        CMSSigningContext context = new CMSSigningContext(signRequest);
        context.adesPropsConverter = this.adesPropsConverter;
        context.signOptions = (SignOptions)signRequest.getOptions();
        context.signerInfo = (SignerInfo)context.signOptions.getSignerInfos().iterator().next();
        PropertiesUtil.sort((SignerInfo)context.signerInfo, (SignPolicy)((SignPolicy)context.signOptions.getPolicy()));
        context.privateKeyResource = (PrivateKeyResourceImpl)context.signerInfo.getKey();
        context.adesPropsConverter = this.adesPropsConverter;
        context.algoIdSignature = context.signerInfo.getSignatureAlgorithmURI();
        context.signerCert = (X509Certificate)context.privateKeyResource.getCertificate().certificate();
        context.signerCertChain = context.privateKeyResource.getCertificateChain().certificates();
        context.signedProperties = context.signerInfo.getSignedProperties();
        context.unsignedProperties = context.signerInfo.getUnsignedProperties();
        LOG.debug("context created");
        context.algoIdDigest = context.signerInfo.getDigestAlgorithmURI();
        if (context.algoIdDigest == null || context.algoIdDigest.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "missing digest algorithm");
        }
        context.env = env;
        return context;
    }

    /*
     * Loose catch block
     */
    private SignedDataResponse signCounter(SignRequest signRequest, Environment env) throws CoreException {
        try {
            LOG.debug("prepare CMS/CAdES counter signing ...");
            CMSSigningContext context = this.createContext(signRequest, env);
            context.type = "CMS/CAdES counter sign";
            Document content = null;
            CMSSignedData cms = null;
            SignerInformationStore signerInfos = null;
            SignerInformation signerInformationToCounterSign = null;
            byte[] signature = null;
            try {
                CounterSignerInfo ci;
                SignerId si;
                content = (Document)((DataToBeSigned)signRequest.getDataToBeSigned().get(0)).getDocuments().get(0);
                if (content == null) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "can not counter sign document, document is null");
                }
                if (!(content instanceof CMSSignedDocument)) {
                    content = new CMSSimpleParser().parseDocument((Options<?>)context.getSignOptions(), content);
                }
                if (!(content instanceof CMSSignedDocument)) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "can not counter sign unsigned document");
                }
                cms = (CMSSignedData)((CMSSignedDocument)content).getParsed();
                if (cms == null) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign creating cms signed data");
                }
                signerInfos = cms.getSignerInfos();
                signerInformationToCounterSign = signerInfos.get(si = (SignerId)(ci = (CounterSignerInfo)context.signerInfo).getSignatureSelector());
                if (signerInformationToCounterSign == null) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign not finding SignedInfo to counter sign");
                }
                signature = signerInformationToCounterSign.getSignature();
                if (signature == null || signature.length == 0) {
                    throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign extracting signature value");
                }
                context.gen = new CMSSignedDataStreamGenerator();
                ContentSigner contentSigner = this.createContentSigner(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(context.algoIdSignature), (AbstractKeyResource<?>)context.privateKeyResource);
                JcaDigestCalculatorProviderBuilder digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder();
                JcaSignerInfoGeneratorBuilder signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(digestCalculatorProvider.build());
                context.gen.addSignerInfoGenerator(signerInfoGenerator.build(contentSigner, context.signerCert));
                for (Certificate c : context.signerCertChain) {
                    context.certs.add(new X509CertificateHolder(c.getEncoded()));
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (OperatorCreationException e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with bc operator creation: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with io failure: " + e.getMessage(), (Throwable)e);
            }
            catch (CertificateEncodingException e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign with certificate: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to prepare sign counter CMS/CAdES with not expected Exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                LOG.debug("CMS/CAdES counter sign prepared");
            }
            LOG.debug("CMS/CAdES sign counter processing ...");
            byte[] cmsCounterSign = this.signCounterInt(context, signature);
            LOG.debug("CMS/CAdES sign counter update cms");
            CMSSignedData cmsCounter = this.createCounterSignature(context, cms, signerInfos, signerInformationToCounterSign, cmsCounterSign);
            try {
                LOG.debug("prepare response...");
                SimpleSignedData signedData = new SimpleSignedData(content, (Document)new CMSSignedDocumentImpl(UUID.randomUUID().toString(), UUID.randomUUID().toString(), (DataHandler)new SimpleDataHandler((InputStream)new ByteArrayInputStream(cmsCounter.getEncoded()), "application/pkcs7-signature"), "application/pkcs7-signature"));
                ArrayList<SimpleSignedData> datas = new ArrayList<SimpleSignedData>();
                datas.add(signedData);
                SignedDataResponseImpl signedDataResponseImpl = new SignedDataResponseImpl(datas);
                return signedDataResponseImpl;
            }
            catch (Exception e) {
                throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign counter returning response with not expected exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                LOG.debug("response prepared");
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LOG.debug("CMS/CAdES sign counter processed");
        }
    }

    private CMSSignedData createCounterSignature(CMSSigningContext context, CMSSignedData cms, SignerInformationStore signerInfos, SignerInformation signerInformationToCounterSign, byte[] cmsCounterSign) throws CSLSignatureException {
        CMSSignedData cmsCounter = null;
        try {
            CMSSignedData cmsPlainCounter = new CMSSignedData((InputStream)new ByteArrayInputStream(cmsCounterSign));
            SignerInformation counterSignerInfo = (SignerInformation)cmsPlainCounter.getSignerInfos().getSigners().iterator().next();
            SignerInformationStore counterSigners = new SignerInformationStore(counterSignerInfo);
            SignerInformation counterSignerInformation = SignerInformation.addCounterSigners((SignerInformation)signerInformationToCounterSign, (SignerInformationStore)counterSigners);
            ArrayList<SignerInformation> updateSignerInfos = new ArrayList<SignerInformation>();
            for (SignerInformation signerInfo : signerInfos.getSigners()) {
                if (signerInfo == signerInformationToCounterSign) {
                    updateSignerInfos.add(counterSignerInformation);
                    continue;
                }
                updateSignerInfos.add(signerInfo);
            }
            LOG.debug("updating CAdES with counter signature...");
            cmsCounter = CMSSignedData.replaceSigners((CMSSignedData)cms, (SignerInformationStore)new SignerInformationStore(updateSignerInfos));
            cmsCounter = this.updateCMS(cmsCounter, context);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign at updating cms with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        return cmsCounter;
    }

    private byte[] signCounterInt(CMSSigningContext context, byte[] signature) throws CSLSignatureException {
        byte[] cmsCounterSign = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            LOG.debug("counter signing CMS/CAdES...");
            try (OutputStream signedContent = context.gen.open((OutputStream)baos, true);){
                signedContent.write(signature);
            }
            cmsCounterSign = baos.toByteArray();
        }
        catch (IOException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign creating counter signature", (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "failed to sign creating counter signature with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        LOG.debug("CMS/CAdES counter signature created");
        return cmsCounterSign;
    }

    private CMSSignedData updateCMS(CMSSignedData cmsSignedData, CMSSigningContext context) throws CSLSignatureException {
        CMSSignedData collectedOCSPs;
        LOG.debug("updating global CMS container: certificates, attribute certificates and revocation informations");
        Collection<X509CertificateHolder> collectedCerts = context.certs;
        Collection<X509AttributeCertificateHolder> collectedAttrCerts = context.attrCerts;
        Collection<X509CRLHolder> collectedCRLs = context.crls;
        context.certs = cmsSignedData.getCertificates().getMatches(null);
        context.attrCerts = cmsSignedData.getAttributeCertificates().getMatches(null);
        context.crls = cmsSignedData.getCRLs().getMatches(null);
        context.addCertificates(collectedCerts);
        context.addAttributeCertificates(collectedAttrCerts);
        context.addCRLs(collectedCRLs);
        if (!context.otherInfo.isEmpty()) {
            collectedOCSPs = this.cmsUtils.getOthersFromStore(CMSObjectIdentifiers.id_ri_ocsp_response, (Store)new CollectionStore(context.otherInfo));
            context.addCRLs((Collection<?>)collectedOCSPs);
        }
        LOG.debug("update prepared");
        try {
            collectedOCSPs = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)cmsSignedData, (Store)new JcaCertStore(context.certs), (Store)new JcaCertStore(context.attrCerts), (Store)new CollectionStore(context.crls));
            return collectedOCSPs;
        }
        catch (CMSException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "recoding certificate, attribute certificates and CRLs failed at cms: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "replacing certificate, attribute certificates and CRLs failed with not expected exception: " + e.getMessage(), (Throwable)e);
        }
        finally {
            LOG.debug("CMS updated");
        }
    }

    private ContentSigner createContentSigner(String signatureAlgorithm, AbstractKeyResource<?> keyResource) throws CSLSignatureException {
        try {
            PrivateKeyResourceImpl privateKeyResource = (PrivateKeyResourceImpl)keyResource;
            JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
            jcaContentSignerBuilder.setProvider("CPP");
            return jcaContentSignerBuilder.build((PrivateKey)privateKeyResource);
        }
        catch (OperatorCreationException e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign creating content signer creating operator: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "failed to sign creating content signer with not expected exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

