/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.impl;

import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.SignedDocument;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.sign.SignRequest;
import java.util.List;

public class CMSRequestUtils {
    CMSRequestUtils() {
    }

    public Document getContentDocument(SignRequest signRequest) throws CSLSignatureException {
        List dataToBeSigned = signRequest.getDataToBeSigned();
        if (dataToBeSigned == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "no data to be signed at request found");
        }
        if (dataToBeSigned.size() != 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only one data to be signed exactly is required and supported");
        }
        List contentDocuments = ((DataToBeSigned)dataToBeSigned.get(0)).getDocuments();
        if (contentDocuments == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "no documents at data to be signed at request found");
        }
        if (contentDocuments.size() != 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "one document exactly at data to be signed is required and supported");
        }
        Document contentDocumentToSign = (Document)contentDocuments.get(0);
        if (contentDocumentToSign == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "no document at data to be signed at request found");
        }
        return contentDocumentToSign;
    }

    public String checkDigestAlgorithmURI(SignedDocument<?> detachedSignatureDocument) throws CSLSignatureException {
        if (detachedSignatureDocument == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "provided detached signature document can not be null");
        }
        String detachedDigestAlgorithmURI = detachedSignatureDocument.getDigestAlgorithmURI();
        if (detachedDigestAlgorithmURI == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "provided detached signature document does not specify a digest algorithm, null");
        }
        if (detachedDigestAlgorithmURI.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "provided detached signature document signature does not specify a digest algorithm, empty");
        }
        return detachedDigestAlgorithmURI;
    }
}

