/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;

public class CMSAttributeTable {
    private Hashtable<ASN1ObjectIdentifier, Object> attributes = new Hashtable();

    public String toString() {
        return super.toString() + this.attributes.keySet();
    }

    public CMSAttributeTable() {
    }

    public CMSAttributeTable(Hashtable attrs) {
        this.attributes = this.copyTable(attrs);
    }

    public CMSAttributeTable(ASN1EncodableVector v) {
        for (int i = 0; i != v.size(); ++i) {
            Attribute a = Attribute.getInstance((Object)v.get(i));
            this.addAttribute(a.getAttrType(), a);
        }
    }

    public CMSAttributeTable(ASN1Set s) {
        for (int i = 0; i != s.size(); ++i) {
            Attribute a = Attribute.getInstance((Object)s.getObjectAt(i));
            this.addAttribute(a.getAttrType(), a);
        }
    }

    public CMSAttributeTable(Attribute attr) {
        this.addAttribute(attr.getAttrType(), attr);
    }

    public CMSAttributeTable(Attributes attrs) {
        this(ASN1Set.getInstance((Object)attrs.toASN1Primitive()));
    }

    public void addAttribute(Attribute a) {
        this.addAttribute(a.getAttrType(), a);
    }

    public void addAttribute(ASN1ObjectIdentifier oid, Attribute a) {
        Object value = this.attributes.get(oid);
        if (value == null) {
            this.attributes.put(oid, a);
        } else {
            Vector<Attribute> v;
            if (value instanceof Attribute) {
                v = new Vector<Attribute>();
                v.addElement((Attribute)value);
                v.addElement(a);
            } else {
                v = (Vector<Attribute>)value;
                v.addElement(a);
            }
            this.attributes.put(oid, v);
        }
    }

    public Attribute get(ASN1ObjectIdentifier oid) {
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            return (Attribute)((Vector)value).elementAt(0);
        }
        return (Attribute)value;
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier oid) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Object value = this.attributes.get(oid);
        if (value instanceof Vector) {
            Enumeration e = ((Vector)value).elements();
            while (e.hasMoreElements()) {
                v.add((ASN1Encodable)e.nextElement());
            }
        } else if (value != null) {
            v.add((ASN1Encodable)((Attribute)value));
        }
        return v;
    }

    public int size() {
        int size = 0;
        Enumeration<Object> en = this.attributes.elements();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o instanceof Vector) {
                size += ((Vector)o).size();
                continue;
            }
            ++size;
        }
        return size;
    }

    public Hashtable<ASN1ObjectIdentifier, Object> toHashtable() {
        return this.copyTable(this.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Enumeration<Object> e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            if (value instanceof Vector) {
                Enumeration en = ((Vector)value).elements();
                while (en.hasMoreElements()) {
                    v.add((ASN1Encodable)Attribute.getInstance(en.nextElement()));
                }
                continue;
            }
            v.add((ASN1Encodable)Attribute.getInstance((Object)value));
        }
        return v;
    }

    public Attributes toASN1Structure() {
        return new Attributes(this.toASN1EncodableVector());
    }

    private Hashtable<ASN1ObjectIdentifier, Object> copyTable(Hashtable in) {
        Hashtable<ASN1ObjectIdentifier, Object> out = new Hashtable<ASN1ObjectIdentifier, Object>();
        Enumeration e = in.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = in.get(key);
            if (!(key instanceof ASN1ObjectIdentifier) || !(value instanceof Attribute) && !(value instanceof Vector)) continue;
            out.put((ASN1ObjectIdentifier)key, value);
        }
        return out;
    }

    public CMSAttributeTable add(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        CMSAttributeTable newTable = new CMSAttributeTable(this.attributes);
        newTable.addAttribute(attrType, new Attribute(attrType, (ASN1Set)new DERSet(attrValue)));
        return newTable;
    }

    public CMSAttributeTable remove(ASN1ObjectIdentifier attrType) {
        CMSAttributeTable newTable = new CMSAttributeTable(this.attributes);
        newTable.attributes.remove(attrType);
        return newTable;
    }

    public AttributeTable toAttributeTable() {
        return new AttributeTable(this.attributes);
    }
}

