/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign.doc.impl;

import de.governikus.csl.cms.sign.doc.CMSSignedDocument;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.impl.ParsedDocumentImpl;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.sign.SignatureType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.UUID;
import javax.activation.DataHandler;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSSignedDocumentImpl
extends ParsedDocumentImpl<CMSSignedData>
implements CMSSignedDocument {
    public static final String DEFAULT_CMS_MIME_TYPE = "application/pkcs7-signature";
    private static final Logger LOGGER = LoggerFactory.getLogger(CMSSignedDocumentImpl.class);
    protected byte[] digestValue;
    protected String digestAlgorithmURI;
    private String friendlyName;
    protected SignatureType signatureType;

    public CMSSignedDocumentImpl(String id, String name, DataHandler dataHandler, String contentType) {
        super(id, name, dataHandler, contentType);
    }

    public CMSSignedDocumentImpl(String id, String name, DataHandler dataHandler, String contentType, ReferenceResolver referenceResolver) {
        super(id, name, dataHandler, contentType, referenceResolver);
    }

    public CMSSignedDocumentImpl(DataHandler dataHandler) {
        this(UUID.randomUUID().toString(), UUID.randomUUID().toString(), dataHandler, DEFAULT_CMS_MIME_TYPE);
    }

    public synchronized CMSSignedData getParsed() {
        if (this.parsedDocumentType == null) {
            try {
                InputStream tmp = null;
                ReferenceResolver referenceResolver = this.getReferenceResolver();
                tmp = referenceResolver != null && referenceResolver.canResolve(super.getName()) ? referenceResolver.getReference(super.getName()) : super.getInputStream();
                try (InputStream is = tmp;){
                    this.parsedDocumentType = new CMSSignedData(is);
                    this.signatureType = ((CMSSignedData)this.parsedDocumentType).isDetachedSignature() ? SignatureType.DETACHED : SignatureType.ENVELOPED;
                    SignerInformation si = this.getFirstSigner();
                    this.initDigestAlgorithmURI(si);
                    this.initDigestValue(si);
                    this.initFriendlyName(si);
                }
            }
            catch (IOException | CMSException e) {
                LOGGER.error("Failed to get parsed CMS.", e);
            }
        }
        return (CMSSignedData)this.parsedDocumentType;
    }

    private SignerInformation getFirstSigner() {
        SignerInformationStore signerInformationStore = ((CMSSignedData)this.parsedDocumentType).getSignerInfos();
        Collection signers = signerInformationStore.getSigners();
        if (signers == null || signers.isEmpty()) {
            throw new IllegalArgumentException("no signers found");
        }
        return (SignerInformation)signers.iterator().next();
    }

    private void initFriendlyName(SignerInformation si) {
        ASN1Encodable[] attributeCMSFriendlyNameValues;
        Attribute attributeCMSFriendlyName = si.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
        if (attributeCMSFriendlyName != null && (attributeCMSFriendlyNameValues = attributeCMSFriendlyName.getAttributeValues()) != null) {
            DERBMPString asn1FriendlyNameValue = (DERBMPString)attributeCMSFriendlyNameValues[0].toASN1Primitive();
            this.friendlyName = asn1FriendlyNameValue.getString();
        }
    }

    private void initDigestValue(SignerInformation si) {
        Attribute attributeMessageDigest = si.getSignedAttributes().get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        if (attributeMessageDigest == null) {
            throw new IllegalArgumentException("missing message digest attribute");
        }
        ASN1Encodable[] attributeMessageDigestValues = attributeMessageDigest.getAttributeValues();
        if (attributeMessageDigestValues == null || attributeMessageDigestValues.length == 0) {
            throw new IllegalArgumentException("missing message digest attribute value");
        }
        this.digestValue = ((DEROctetString)attributeMessageDigestValues[0].toASN1Primitive()).getOctets();
    }

    private void initDigestAlgorithmURI(SignerInformation si) {
        AlgorithmIdentifier digestAlgorithmID = si.getDigestAlgorithmID();
        if (digestAlgorithmID == null) {
            throw new IllegalArgumentException("no digest algorithm OID found at CMS");
        }
        this.digestAlgorithmURI = XMLOIDJCEAlgorithmMapper.getMapper().mapOIDAlgorithmXML(digestAlgorithmID.getAlgorithm().getId());
    }

    public String getFriendlyName() {
        this.getParsed();
        return this.friendlyName;
    }

    public String getDigestAlgorithmURI() {
        this.getParsed();
        return this.digestAlgorithmURI;
    }

    public byte[] getContentDocumentDigestValue() {
        this.getParsed();
        byte[] tmp = new byte[this.digestValue.length];
        System.arraycopy(this.digestValue, 0, tmp, 0, this.digestValue.length);
        return tmp;
    }

    @Override
    public SignatureType getSignatureType() {
        this.getParsed();
        return this.signatureType;
    }
}

