/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.cms.sign;

import de.governikus.csl.cms.sign.impl.CMSAttributeTable;
import de.governikus.csl.cms.sign.props.CMSSignPropertiesConverterManager;
import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.sign.impl.AbstractSigningContext;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.res.impl.PrivateKeyResourceImpl;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignedProperties;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.UnsignedProperties;
import de.governikus.csl.uom.util.Environment;
import java.io.File;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.tsp.TimeStampToken;

public class CMSSigningContext
extends AbstractSigningContext {
    public CMSSignPropertiesConverterManager adesPropsConverter;
    public Collection<X509AttributeCertificateHolder> attrCerts = new ArrayList<X509AttributeCertificateHolder>();
    public Collection<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>();
    public Collection<X509CRLHolder> crls = new ArrayList<X509CRLHolder>();
    public CMSSignedDataStreamGenerator gen;
    public Collection<Object> otherInfo = new ArrayList<Object>();
    public Collection<TimeStampToken> signatureTimeStampTokens = new ArrayList<TimeStampToken>();
    public Map<?, ?> signedAttrParameters;
    public CMSAttributeTable signedAttrTable;
    public X509Certificate signerCert;
    public List<Certificate> signerCertChain;
    public Map<?, ?> unsignedAttrParameters;
    public CMSAttributeTable unsignedAttrTable;
    public String algoIdSignature;
    public PrivateKeyResourceImpl privateKeyResource;
    public SignerInfo signerInfo;
    public String algoIdDigest;
    public SignOptions signOptions;
    public SignedProperties signedProperties;
    public UnsignedProperties unsignedProperties;
    public File tempFile = null;
    public boolean enveloped = false;
    public Document contentDocument = null;
    public Environment env = null;
    public String type;
    public byte[] externalDigest;

    public CMSSigningContext(SignRequest signRequest) throws CSLSignatureException {
        super(signRequest);
    }

    public void addAttributeCertificate(AttributeCertificate attrCert) {
        byte[] sig = attrCert.getSignatureValue().getBytes();
        for (X509AttributeCertificateHolder c : this.attrCerts) {
            if (!Arrays.equals(c.getSignature(), sig)) continue;
            return;
        }
        X509AttributeCertificateHolder newAttrCert = new X509AttributeCertificateHolder(attrCert);
        this.attrCerts.add(newAttrCert);
    }

    public void addAttributeCertificates(Collection<?> attributeCertificates) {
        if (attributeCertificates == null || attributeCertificates.isEmpty()) {
            return;
        }
        for (Object a : attributeCertificates) {
            if (a instanceof AttributeCertificate) {
                this.addAttributeCertificate((AttributeCertificate)a);
            }
            if (!(a instanceof X509AttributeCertificateHolder)) continue;
            this.addAttributeCertificate((X509AttributeCertificateHolder)a);
        }
    }

    private void addAttributeCertificate(X509AttributeCertificateHolder a) {
        byte[] sig = a.getSignature();
        for (X509AttributeCertificateHolder c : this.attrCerts) {
            if (!Arrays.equals(c.getSignature(), sig)) continue;
            return;
        }
        this.attrCerts.add(a);
    }

    public void addCertificate(X509Certificate x509certificate) {
        if (x509certificate == null) {
            return;
        }
        byte[] sig = x509certificate.getSignature();
        for (X509CertificateHolder c : this.certs) {
            if (!Arrays.equals(c.getSignature(), sig)) continue;
            return;
        }
        try {
            this.certs.add(new X509CertificateHolder(x509certificate.getEncoded()));
        }
        catch (Exception e) {
            return;
        }
    }

    public void addCertificate(X509CertificateHolder x509certificate) {
        if (x509certificate == null) {
            return;
        }
        byte[] sig = x509certificate.getSignature();
        for (X509CertificateHolder c : this.certs) {
            if (!Arrays.equals(c.getSignature(), sig)) continue;
            return;
        }
        this.certs.add(x509certificate);
    }

    public void addCertificates(Collection<?> certificates) {
        if (certificates == null || certificates.isEmpty()) {
            return;
        }
        for (Object c : certificates) {
            try {
                if (c instanceof X509Certificate) {
                    this.addCertificate((X509Certificate)c);
                }
                if (!(c instanceof X509CertificateHolder)) continue;
                this.addCertificate((X509CertificateHolder)c);
            }
            catch (Exception exception) {}
        }
    }

    public void addCRL(X509CRL x509CRL) {
        if (x509CRL == null) {
            return;
        }
        byte[] enc = null;
        try {
            enc = x509CRL.getEncoded();
        }
        catch (Exception e) {
            return;
        }
        for (X509CRLHolder c : this.crls) {
            try {
                if (!Arrays.equals(c.getEncoded(), enc)) continue;
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            this.crls.add(new X509CRLHolder(enc));
        }
        catch (Exception e) {
            return;
        }
    }

    public void addCRL(X509CRLHolder x509CRL) {
        if (x509CRL == null) {
            return;
        }
        byte[] enc = null;
        try {
            enc = x509CRL.getEncoded();
        }
        catch (Exception e) {
            return;
        }
        for (X509CRLHolder c : this.crls) {
            try {
                if (!Arrays.equals(c.getEncoded(), enc)) continue;
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        this.crls.add(x509CRL);
    }

    public void addOtherRevocationInfoFormat(DERTaggedObject otherRevocationInfoFormat) {
    }

    public void addCRLs(Collection<?> crls) {
        if (crls == null || crls.isEmpty()) {
            return;
        }
        for (Object c : crls) {
            if (c instanceof DERTaggedObject) {
                this.addOtherRevocationInfoFormat((DERTaggedObject)c);
                continue;
            }
            if (c instanceof X509CRL) {
                this.addCRL((X509CRL)c);
                continue;
            }
            if (!(c instanceof X509CRLHolder)) continue;
            this.addCRL((X509CRLHolder)c);
        }
    }

    public void addCRLs(CRL[] crls) {
        if (crls == null || crls.length == 0) {
            return;
        }
        for (CRL crl : crls) {
            if (!(crl instanceof X509CRL)) continue;
            this.addCRL((X509CRL)crl);
        }
    }

    public void addOCSP(OCSPResp ocsp) {
        if (ocsp == null) {
            return;
        }
        this.otherInfo.add(ocsp.toASN1Structure());
    }

    public void addOCSPs(OCSPResp[] ocsps) {
        if (ocsps == null || ocsps.length == 0) {
            return;
        }
        for (OCSPResp ocsp : ocsps) {
            this.addOCSP(ocsp);
        }
    }
}

