/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import opencard.core.util.Tracer;

public class URLClassLoader
extends ClassLoader {
    private Tracer itracer = new Tracer((Object)this, URLClassLoader.class);
    protected Hashtable classCache = new Hashtable();
    protected Hashtable byteCache = new Hashtable();
    protected URL url = null;
    protected String archive = null;
    protected boolean archiveLoaded = false;

    public URLClassLoader(URL url) {
        this.url = url;
    }

    public URLClassLoader(URL url, String archive) {
        this(url);
        this.archive = archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        boolean needSecurityCheck;
        SecurityManager security = System.getSecurityManager();
        int lastDot = name.lastIndexOf(46);
        String packageName = lastDot >= 0 ? name.substring(0, lastDot) : null;
        boolean bl = needSecurityCheck = security != null && packageName != null;
        if (needSecurityCheck) {
            security.checkPackageAccess(packageName);
        }
        Hashtable hashtable = this.classCache;
        synchronized (hashtable) {
            if (this.classCache.containsKey(name)) {
                return (Class)this.classCache.get(name);
            }
            try {
                Class<?> c2 = this.findSystemClass(name);
                this.itracer.debug("loadClass", "Found System Class: " + name);
                this.classCache.put(name, c2);
                return c2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (needSecurityCheck) {
                    security.checkPackageDefinition(packageName);
                }
                byte[] data = this.loadClassData(name);
                c = this.defineClass(name, data, 0, data.length);
                this.classCache.put(name, c);
                this.itracer.debug("loadClass", "Loaded class from URL: " + name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected synchronized byte[] loadClassData(String name) throws ClassNotFoundException {
        String classPath = name.replace('.', '/');
        String classFile = classPath + ".class";
        if (this.archive != null) {
            if (!this.archiveLoaded) {
                this.loadArchive(this.url, this.archive);
            }
            if (this.byteCache.containsKey(classFile)) {
                byte[] bytes = (byte[])this.byteCache.get(classFile);
                this.byteCache.remove(classFile);
                return bytes;
            }
            throw new ClassNotFoundException("archive: " + this.archive + " does not contain:" + classFile);
        }
        BufferedInputStream bis = null;
        try {
            URL classURL = new URL(this.url, classFile);
            InputStream is = classURL.openStream();
            bis = new BufferedInputStream(is);
            byte[] byArray = this.inputStreamToByteArray(bis);
            return byArray;
        }
        catch (MalformedURLException mue) {
            throw new ClassNotFoundException(mue.toString());
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(ioe.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ClassNotFoundException(t.toString());
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void loadArchive(URL url, String archive) throws ClassNotFoundException {
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            URL archiveURL = new URL(url, archive);
            InputStream is = archiveURL.openStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                byte[] data = this.inputStreamToByteArray(zis);
                this.byteCache.put(name, data);
            }
            this.archiveLoaded = true;
        }
        catch (MalformedURLException e) {
            throw new ClassNotFoundException(e.toString());
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] inputStreamToByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int nextByte;
            while ((nextByte = is.read()) != -1) {
                baos.write(nextByte);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

