/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.util.Hashtable;
import opencard.core.util.HexString;
import opencard.opt.util.Tag;

public class TLV {
    private Tag tag;
    private int length;
    private byte[] value;
    private TLV parent;
    private TLV sibling;
    private TLV child;
    private TLV lastChild;

    public TLV() {
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
    }

    public TLV(byte[] binary) {
        int[] offset = new int[]{0};
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
        TLV.fromBinary(binary, offset, this, null);
    }

    public TLV(Tag _tag, byte[] _value) {
        int[] offset = new int[]{0};
        TLV newTLV = new TLV();
        this.tag = new Tag(_tag);
        if (this.tag.isConstructed()) {
            while (offset[0] < _value.length) {
                TLV.fromBinary(_value, offset, newTLV, this);
            }
        } else {
            this.length = _value != null ? _value.length : 0;
            this.value = _value;
            this.child = null;
            this.lastChild = null;
        }
        this.parent = null;
        this.sibling = null;
    }

    public TLV(Tag tag, int number) {
        int i = 0;
        this.tag = new Tag(tag);
        this.value = number < 256 ? new byte[1] : (number < 65536 ? new byte[2] : (number < 0x1000000 ? new byte[3] : new byte[4]));
        for (i = this.value.length - 1; i >= 0; --i) {
            this.value[i] = (byte)(number % 256);
            number /= 256;
        }
        this.length = this.value.length;
        this.child = null;
        this.lastChild = null;
        this.parent = null;
        this.sibling = null;
    }

    public TLV(Tag tag, TLV tlv) {
        this.tag = new Tag(tag);
        this.tag.setConstructed(true);
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = tlv;
        this.lastChild = tlv;
        this.length = tlv != null ? tlv.tag.size() + tlv.lenBytes() + tlv.length : 0;
    }

    public TLV add(TLV tlv) {
        int originalReprLength = 0;
        int deltaReprLength = 0;
        if (this.tag.isConstructed()) {
            tlv.parent = this;
            tlv.sibling = null;
            if (this.lastChild != null) {
                this.lastChild.sibling = tlv;
            }
            this.lastChild = tlv;
            TLV iterTLV = this;
            while (iterTLV != null) {
                originalReprLength = iterTLV.lenBytes();
                iterTLV.length += tlv.length + tlv.tag.size() + tlv.lenBytes() + deltaReprLength;
                deltaReprLength += iterTLV.lenBytes() - originalReprLength;
                iterTLV = iterTLV.parent;
            }
            return this;
        }
        return null;
    }

    public TLV findTag(Tag tag, TLV cursor) {
        TLV iterTLV = cursor == null ? this.child : cursor.sibling;
        if (tag == null) {
            return iterTLV;
        }
        while (iterTLV != null) {
            if (iterTLV.tag.equals(tag)) {
                return iterTLV;
            }
            iterTLV = iterTLV.sibling;
        }
        return null;
    }

    public static void fromBinary(byte[] binary, int[] offset, TLV tlv, TLV parent) {
        int oldOffset = offset[0];
        TLV iterTLV = null;
        tlv.tag.fromBinary(binary, offset);
        tlv.length = 0;
        if ((binary[offset[0]] & 0xFFFFFF80) == 0) {
            tlv.length += binary[offset[0]];
        } else {
            int j = 0;
            for (int numBytes = binary[offset[0]] & 0x7F; numBytes > 0; --numBytes) {
                offset[0] = offset[0] + 1;
                j = binary[offset[0]];
                tlv.length = tlv.length + (j < 0 ? (j += 256) : j);
                if (numBytes <= 1) continue;
                tlv.length *= 256;
            }
        }
        offset[0] = offset[0] + 1;
        if (tlv.tag.isConstructed()) {
            tlv.value = null;
            tlv.child = new TLV();
            TLV.fromBinary(binary, offset, tlv.child, tlv);
            iterTLV = tlv.child;
            while (offset[0] <= oldOffset + tlv.length) {
                iterTLV.sibling = new TLV();
                TLV.fromBinary(binary, offset, iterTLV.sibling, tlv);
                iterTLV = iterTLV.sibling;
            }
            tlv.lastChild = iterTLV;
        } else {
            tlv.child = null;
            tlv.sibling = null;
            tlv.value = new byte[tlv.length];
            System.arraycopy(binary, offset[0], tlv.value, 0, tlv.length);
            offset[0] = offset[0] + tlv.length;
        }
        tlv.parent = parent;
    }

    private int lenBytes() {
        if (this.length < 128) {
            return 1;
        }
        if (this.length < 256) {
            return 2;
        }
        if (this.length < 65536) {
            return 3;
        }
        if (this.length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public static int lenBytes(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public int length() {
        return this.length;
    }

    public static byte[] lengthToBinary(int length) {
        byte[] binary = new byte[TLV.lenBytes(length)];
        if (length < 128) {
            binary[0] = (byte)length;
        } else if (length < 256) {
            binary[0] = -127;
            binary[1] = (byte)length;
        } else if (length < 65536) {
            binary[0] = -126;
            binary[1] = (byte)(length / 256);
            binary[2] = (byte)(length % 256);
        } else if (length < 0x1000000) {
            binary[0] = -125;
            binary[1] = (byte)(length / 65536);
            binary[2] = (byte)(length / 256);
            binary[3] = (byte)(length % 256);
        }
        return binary;
    }

    public void setValue(byte[] newValue) {
        int originalReprLength = 0;
        int deltaReprLength = 0;
        originalReprLength = this.lenBytes();
        int oldLength = this.length;
        this.value = newValue;
        this.length = newValue != null ? this.value.length : 0;
        deltaReprLength = this.lenBytes() - originalReprLength;
        TLV iterTLV = this.parent;
        while (iterTLV != null) {
            originalReprLength = iterTLV.lenBytes();
            iterTLV.length += this.length - oldLength + deltaReprLength;
            deltaReprLength += iterTLV.lenBytes() - originalReprLength;
            iterTLV = iterTLV.parent;
        }
    }

    public Tag tag() {
        return this.tag;
    }

    public byte[] toBinary() {
        int[] offset = new int[]{0};
        int totalLength = this.tag.size() + this.lenBytes() + this.length;
        byte[] binary = new byte[totalLength];
        this.toBinaryHelper(binary, offset, totalLength);
        return binary;
    }

    public byte[] toBinaryContent() {
        int[] offset = new int[]{0};
        int totalLength = this.length;
        byte[] binary = new byte[totalLength];
        this.toBinaryHelperContent(binary, offset, totalLength);
        return binary;
    }

    private void toBinaryHelper(byte[] binary, int[] offset, int max) {
        this.tag.toBinary(binary, offset);
        this.toBinaryLength(binary, offset);
        if (this.child != null) {
            this.child.toBinaryHelper(binary, offset, max);
        } else if (this.value != null) {
            System.arraycopy(this.value, 0, binary, offset[0], this.value.length);
            offset[0] = offset[0] + this.value.length;
        }
        if (this.sibling != null && offset[0] < max) {
            this.sibling.toBinaryHelper(binary, offset, max);
        }
    }

    private void toBinaryHelperContent(byte[] binary, int[] offset, int max) {
        if (this.child != null) {
            this.child.toBinaryHelper(binary, offset, max);
        } else if (this.value != null) {
            System.arraycopy(this.value, 0, binary, offset[0], this.value.length);
            offset[0] = offset[0] + this.value.length;
        }
    }

    private void toBinaryLength(byte[] binary, int[] offset) {
        if (this.length < 128) {
            binary[offset[0]] = (byte)this.length;
        } else if (this.length < 256) {
            binary[offset[0]] = -127;
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)this.length;
        } else if (this.length < 65536) {
            binary[offset[0]] = -126;
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length / 256);
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length % 256);
        } else if (this.length < 0x1000000) {
            binary[offset[0]] = -125;
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length / 65536);
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length / 256);
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length % 256);
        }
        offset[0] = offset[0] + 1;
    }

    public String toString() {
        return this.toString(null, 0);
    }

    public String toString(Hashtable ht, int level) {
        Object s = "";
        int i = 0;
        for (i = 0; i < level; ++i) {
            s = (String)s + " ";
        }
        s = ht == null ? (String)s + "[" + this.tag + " " + this.length + "] " : (String)s + ht.get(this.tag) + " ";
        if (this.tag.isConstructed()) {
            s = (String)s + "\n";
            for (i = 0; i < level; ++i) {
                s = (String)s + " ";
            }
        }
        s = (String)s + "( ";
        if (this.tag.isConstructed()) {
            s = (String)s + "\n";
            s = (String)s + this.child.toString(ht, level + 2);
            for (i = 0; i < level; ++i) {
                s = (String)s + " ";
            }
            s = (String)s + ")\n";
        } else {
            boolean fPrintable = true;
            if (this.value != null) {
                for (i = 0; i < this.value.length; ++i) {
                    if (this.value[i] >= 32) continue;
                    fPrintable = false;
                }
                if (fPrintable) {
                    s = (String)s + "\"" + new String(this.value) + "\"";
                } else {
                    s = (String)s + "'";
                    for (i = 0; i < this.value.length; ++i) {
                        s = (String)s + HexString.hexify(this.value[i]);
                    }
                    s = (String)s + "'";
                }
            }
            s = (String)s + " )";
        }
        if (this.sibling != null) {
            s = (String)s + "\n";
            s = (String)s + this.sibling.toString(ht, level);
        }
        return s;
    }

    public byte[] valueAsByteArray() {
        return this.value;
    }

    public int valueAsNumber() {
        int i = 0;
        int j = 0;
        int number = 0;
        for (i = 0; i < this.value.length; ++i) {
            j = this.value[i];
            number = number * 256 + (j < 0 ? (j += 256) : j);
        }
        return number;
    }
}

