/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal.protocol;

import opencard.core.util.Tracer;
import opencard.opt.terminal.protocol.T1Block;
import opencard.opt.terminal.protocol.T1BlockEDCErrorException;
import opencard.opt.terminal.protocol.T1BlockFactory;
import opencard.opt.terminal.protocol.T1BlockLengthException;
import opencard.opt.terminal.protocol.T1Exception;
import opencard.opt.terminal.protocol.T1IOException;
import opencard.opt.terminal.protocol.T1TimeoutException;
import opencard.opt.terminal.protocol.T1UnknownBlockException;

public abstract class T1Protocol {
    private static Tracer ctracer = new Tracer(T1Protocol.class);
    private int hostAddress = 0;
    private int remoteAddress = 0;
    private int blockWaitingTime = 0;
    private int sBlockCounter = 0;
    private int rBlockCounter = 0;
    private int ifs = 32;
    private T1Block[] blockSequence = new T1Block[2];

    T1Protocol() {
        this.setBlockWaitingTime(0);
    }

    public T1Protocol(int stdHostAddress, int stdRemoteAddress, int timeout) {
        this.hostAddress = stdHostAddress;
        this.remoteAddress = stdRemoteAddress;
        this.setBlockWaitingTime(timeout);
    }

    public void open() throws T1Exception {
        this.initProtocol();
    }

    public void close() {
    }

    public int getBlockWaitingTime() {
        return this.blockWaitingTime;
    }

    public void setBlockWaitingTime(int timeout) {
        this.blockWaitingTime = timeout;
    }

    public int getHostAddress() {
        return this.hostAddress;
    }

    public int getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getSendSequenceCounter() {
        return this.sBlockCounter;
    }

    public void setSendSequenceCounter(int val) {
        this.sBlockCounter = val;
    }

    public void incSendSequenceCounter() {
        ++this.sBlockCounter;
    }

    public int getRecvSequenceCounter() {
        return this.rBlockCounter;
    }

    public void setRecvSequenceCounter(int val) {
        this.rBlockCounter = val;
    }

    public void incRecvSequenceCounter() {
        ++this.rBlockCounter;
    }

    public synchronized byte[] transmit(byte[] sendData) throws T1IOException, T1TimeoutException, T1Exception {
        return this.transmit(this.getRemoteAddress(), sendData);
    }

    public synchronized byte[] transmit(int remoteAddress, byte[] sendData) throws T1IOException, T1TimeoutException, T1Exception {
        return this.transmit(this.getHostAddress(), remoteAddress, sendData);
    }

    public synchronized byte[] transmit(int hostAddress, int remoteAddress, byte[] sendData) throws T1IOException, T1TimeoutException, T1Exception {
        int dataLen = 0;
        byte[] data = null;
        T1Block recvBlock = null;
        for (int bytesLeft = sendData.length; bytesLeft > 0; bytesLeft -= dataLen) {
            T1Block sendBlock;
            if (bytesLeft > this.ifs) {
                throw new T1IOException("block too long - chaining is not supported!");
            }
            dataLen = bytesLeft;
            boolean chaining = false;
            data = new byte[dataLen];
            System.arraycopy(sendData, sendData.length - bytesLeft, data, 0, dataLen);
            this.blockSequence[this.getSendSequenceCounter() % 2] = sendBlock = T1BlockFactory.createIBlock(hostAddress, remoteAddress, 1, this.getSendSequenceCounter(), chaining, data);
            recvBlock = this.internalTransmit(5, sendBlock);
            if (sendBlock.getBlockType() != 0) continue;
            this.incSendSequenceCounter();
        }
        return recvBlock.getDATA();
    }

    protected boolean isBlockComplete(byte[] rawBytes, int len) {
        int hdrlen;
        boolean complete = false;
        if (rawBytes != null && len >= 4 && rawBytes.length >= 4 && (hdrlen = rawBytes[2] & 0xFF) + 4 == len) {
            complete = true;
        }
        return complete;
    }

    private void initProtocol() throws T1Exception {
        T1Block resyncRequest = T1BlockFactory.createSBlock(this.hostAddress, this.remoteAddress, 1, 0, null);
        T1Block ifsRequest = T1BlockFactory.createSBlock(this.hostAddress, this.remoteAddress, 1, 1, new byte[]{(byte)this.ifs});
        for (int i = 0; i < 3; ++i) {
            T1Block result = null;
            try {
                ctracer.debug("initProtocol", "Send S-BLOCK to reader for init-request.");
                result = this.internalTransmit(5, resyncRequest);
                if (result.getBlockType() != 192 || result.getControlBits() != 32) continue;
                this.sBlockCounter = 0;
                this.rBlockCounter = 0;
                result = this.internalTransmit(5, ifsRequest);
                if (result.getBlockType() != 192 || result.getControlBits() != 33) continue;
                if (result.getLEN() == 1) {
                    byte b = result.getDATA()[0];
                    this.ifs = b & 0x7F;
                    if ((b & 0x80) == 128) {
                        this.ifs += 128;
                    }
                    ctracer.debug("initProtocol", "IFS set to " + this.ifs + " + bytes length");
                    return;
                }
                ctracer.error("initProtocol", "IFS response error");
                continue;
            }
            catch (Throwable e) {
                ctracer.critical("initProtocol", "Reader initialization failed.");
            }
        }
        throw new T1Exception("no correct answer on resync request - protocol init failed!");
    }

    protected T1Block internalTransmit(int retryCount, T1Block dataBlock) throws T1Exception {
        T1Block recvBlock = null;
        if (retryCount == 0) {
            throw new T1Exception("to many retries - transfer aborted");
        }
        try {
            recvBlock = this.exchangeData(dataBlock);
            if (recvBlock == null) {
                throw new T1BlockEDCErrorException();
            }
            switch (recvBlock.getBlockType()) {
                case 0: {
                    this.incRecvSequenceCounter();
                    return recvBlock;
                }
                case 128: {
                    recvBlock = this.internalTransmit(retryCount - 1, this.blockSequence[recvBlock.getRequestedSequenceNumber() % 2]);
                    break;
                }
                case 192: {
                    if (recvBlock.getControlBits() == 3) {
                        T1Block wtxResponse = T1BlockFactory.createSBlock(dataBlock.getSourceAddress(), dataBlock.getDestinationAddress(), 1, 35, recvBlock.getDATA());
                        return this.internalTransmit(retryCount - 1, wtxResponse);
                    }
                    if (dataBlock.getBlockType() != 192 || dataBlock.getControlBits() != 0 || recvBlock.getControlBits() != 32) break;
                    return recvBlock;
                }
            }
        }
        catch (T1UnknownBlockException wtxResponse) {
        }
        catch (T1BlockEDCErrorException beee) {
            T1Block resendRequest = T1BlockFactory.createRBlock(this.hostAddress, this.remoteAddress, 1, this.getRecvSequenceCounter(), 1);
            this.incSendSequenceCounter();
            this.blockSequence[this.getSendSequenceCounter() % 2] = resendRequest;
            recvBlock = this.internalTransmit(retryCount - 1, resendRequest);
        }
        return recvBlock;
    }

    protected abstract T1Block exchangeData(T1Block var1) throws T1IOException, T1TimeoutException, T1BlockLengthException, T1UnknownBlockException, T1BlockEDCErrorException;
}

