/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal.protocol;

import opencard.opt.terminal.protocol.T1Block;
import opencard.opt.terminal.protocol.T1Exception;

public class T1BlockFactory {
    public static T1Block createIBlock(int sourceID, int destID, int edcAlg, int sendSequenceNumber, boolean moreDataBit, byte[] data) throws T1Exception {
        int pcb = 0xFF & sendSequenceNumber % 2 << 6;
        if (moreDataBit) {
            pcb = 0xFF & (pcb | 0x20);
        }
        return new T1Block(sourceID, destID, pcb, data, edcAlg);
    }

    public static T1Block createRBlock(int sourceID, int destID, int edcAlg, int sequenceNumber, int errInfo) throws T1Exception {
        int pcb = 0xFF & (0x80 | sequenceNumber % 2 << 4);
        pcb = 0xFF & (pcb | errInfo);
        return new T1Block(sourceID, destID, pcb, null, edcAlg);
    }

    public static T1Block createSBlock(int sourceID, int destID, int edcAlg, int statusInfo, byte[] data) throws T1Exception {
        int pcb = 192;
        pcb = 0xFF & (pcb | statusInfo);
        return new T1Block(sourceID, destID, pcb, data, edcAlg);
    }
}

