/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal.protocol;

import opencard.core.util.HexString;
import opencard.opt.terminal.protocol.T1BlockEDCErrorException;
import opencard.opt.terminal.protocol.T1BlockLengthException;
import opencard.opt.terminal.protocol.T1BlockNotImplementedFeatureException;
import opencard.opt.terminal.protocol.T1DataPacketTooLongException;
import opencard.opt.terminal.protocol.T1Exception;
import opencard.opt.terminal.protocol.T1UnknownBlockException;

public class T1Block {
    public static final int EDC_LDR = 1;
    public static final int EDC_CRC = 2;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_EDC = 1;
    public static final int ERROR_OTHER = 2;
    public static final int S_RESYNCH_REQUEST = 0;
    public static final int S_RESYNCH_RESPONSE = 32;
    public static final int S_IFS_REQUEST = 1;
    public static final int S_IFS_RESPONSE = 33;
    public static final int S_ABORT_REQUEST = 2;
    public static final int S_ABORT_RESPONSE = 34;
    public static final int S_WTX_REQUEST = 3;
    public static final int S_WTX_RESPONSE = 35;
    public static final int S_VPP_STATE_ERROR_RESPONSE = 36;
    public static final int I_BLOCK = 0;
    public static final int R_BLOCK = 128;
    public static final int S_BLOCK = 192;
    private byte NAD = 0;
    private byte PCB = 0;
    private int LEN = 0;
    private byte[] DAT = null;
    private int EDC = 0;
    private int algForEDC = 0;

    public T1Block(int src, int dest, int pcb, byte[] dat, int edcInfo) throws T1BlockLengthException, T1BlockEDCErrorException {
        this.NAD = (byte)(((dest & 7) << 4) + (src & 7));
        this.PCB = (byte)pcb;
        if (dat != null) {
            if (dat.length > 254) {
                throw new T1DataPacketTooLongException("info-field of I-BLOCK must not be greater than 254 bytes");
            }
            this.LEN = dat.length;
        } else {
            this.LEN = 0;
        }
        this.DAT = dat;
        this.algForEDC = edcInfo;
        this.EDC = this.calcEDC();
    }

    public T1Block(byte[] rawBytes, int edcInfo) throws T1BlockLengthException, T1BlockEDCErrorException {
        this.NAD = rawBytes[0];
        this.PCB = rawBytes[1];
        this.LEN = rawBytes[2] & 0xFF;
        this.algForEDC = edcInfo;
        if (rawBytes.length == this.LEN + 4) {
            this.DAT = new byte[this.LEN];
            System.arraycopy(rawBytes, 3, this.DAT, 0, this.LEN);
            this.EDC = rawBytes[rawBytes.length - 1];
        } else if (rawBytes.length == this.LEN + 5) {
            this.disableCRC();
            this.DAT = new byte[this.LEN];
            System.arraycopy(rawBytes, 3, this.DAT, 0, this.LEN);
            this.EDC = (rawBytes[rawBytes.length - 2] << 8) + rawBytes[rawBytes.length - 1];
        } else {
            throw new T1BlockLengthException("block length mismatch detected");
        }
        if (!this.checkEDC()) {
            throw new T1BlockEDCErrorException("EDC error detected");
        }
    }

    public int calcEDC() {
        int edc = 0;
        this.disableCRC();
        if (this.algForEDC == 1) {
            edc = 0;
            edc = this.NAD ^ this.PCB ^ (byte)this.LEN;
            if (this.DAT != null) {
                for (int i = 0; i < this.DAT.length; ++i) {
                    edc ^= this.DAT[i];
                }
            }
        }
        return edc;
    }

    public boolean checkEDC() {
        return this.EDC == this.calcEDC();
    }

    public byte[] getBlock() {
        byte[] block;
        this.disableCRC();
        if (this.DAT != null) {
            block = new byte[this.DAT.length + 4];
            System.arraycopy(this.DAT, 0, block, 3, this.DAT.length);
        } else {
            block = new byte[4];
        }
        block[0] = this.NAD;
        block[1] = this.PCB;
        block[2] = (byte)this.LEN;
        block[block.length - 1] = (byte)(0xFF & this.EDC);
        return block;
    }

    public int getBlockType() throws T1UnknownBlockException {
        if ((~this.PCB & 0x80) != 0) {
            return 0;
        }
        if ((this.PCB & 0xC0) == 128) {
            return 128;
        }
        if ((this.PCB & 0xC0) == 192) {
            return 192;
        }
        throw new T1UnknownBlockException();
    }

    public byte getNAD() {
        return this.NAD;
    }

    public int getSourceID() {
        return this.getNAD() & 7;
    }

    public int getDestID() {
        return this.getNAD() >> 4 & 7;
    }

    public byte getPCB() {
        return this.PCB;
    }

    public int getLEN() {
        return this.LEN;
    }

    public byte[] getDATA() {
        return this.DAT;
    }

    public int getEDC() {
        return this.EDC;
    }

    public int getEDCAlgorithm() {
        return this.algForEDC;
    }

    public int getControlBits() throws T1Exception {
        switch (this.getBlockType()) {
            case 0: {
                return this.getPCB() & 0x7F;
            }
            case 128: 
            case 192: {
                return this.getPCB() & 0x3F;
            }
        }
        return 0;
    }

    private void disableCRC() {
        if (this.algForEDC == 2) {
            throw new T1BlockNotImplementedFeatureException("CRC-algorithm is not implemented!");
        }
    }

    public String toString() {
        StringBuffer info = new StringBuffer("T1-BLOCK\n--------\n");
        info.append("sourceID   = " + this.getSourceID() + "\n");
        info.append("destID     = " + this.getDestID() + "\n");
        info.append("PCB        = " + HexString.hexify(this.PCB) + " (" + Integer.toBinaryString(this.PCB & 0xFF) + ")\n");
        try {
            int blockType = this.getBlockType();
            switch (blockType) {
                case 0: {
                    info.append("blocktype  = I-BLOCK\n");
                    info.append("  N(S)     = " + (this.PCB >> 6) + "\n");
                    info.append("  chaining = " + ((this.PCB & 0x20) == 32 ? "yes\n" : "no\n"));
                    info.append("  infolen  = " + this.LEN + "\n");
                    if (this.getLEN() <= 0) break;
                    info.append("  infodata = " + HexString.hexify(this.DAT) + "\n");
                    break;
                }
                case 128: {
                    info.append("blocktype  = R-BLOCK\n");
                    info.append("  status   = ");
                    switch (this.PCB & 0xF) {
                        case 0: {
                            info.append("error-free\n");
                            break;
                        }
                        case 1: {
                            info.append("EDC or parity error\n");
                            break;
                        }
                        case 2: {
                            info.append("other errors\n");
                            break;
                        }
                        default: {
                            info.append("unknown option\n");
                        }
                    }
                    info.append("  N(R)     = " + (this.PCB >> 4 & 1) + "\n");
                    break;
                }
                case 192: {
                    info.append("blocktype  = S-BLOCK\n");
                    switch (this.PCB & 0x3F) {
                        case 0: {
                            info.append("  status   = RESYNCH request\n");
                            break;
                        }
                        case 32: {
                            info.append("  status   = RESYNCH response\n");
                            break;
                        }
                        case 1: {
                            info.append("  status   = IFS request\n");
                            break;
                        }
                        case 33: {
                            info.append("  status   = IFS response\n");
                            break;
                        }
                        case 2: {
                            info.append("  status   = ABORT request\n");
                            break;
                        }
                        case 34: {
                            info.append("  status   = ABORT response\n");
                            break;
                        }
                        case 3: {
                            info.append("  status   = WTX request\n");
                            break;
                        }
                        case 35: {
                            info.append("  status   = WTX response\n");
                            break;
                        }
                        case 36: {
                            info.append("  status   = VPP state error response\n");
                            break;
                        }
                    }
                    info.append("  infolen  = " + this.LEN + "\n");
                    if (this.getLEN() <= 0) break;
                    info.append("  infodata = " + HexString.hexify(this.DAT) + "\n");
                }
            }
            info.append("EDC algrthm= " + (this.algForEDC == 1 ? "LDR\n" : "CRC16\n"));
            info.append("saved EDC  = " + (this.algForEDC == 1 ? HexString.hexify(this.EDC) : HexString.hexifyShort(this.EDC)));
            info.append(" (calculated: " + (this.algForEDC == 1 ? HexString.hexify(this.calcEDC()) : HexString.hexifyShort(this.calcEDC())) + ")\n");
            info.append("raw bytes  = " + HexString.hexify(this.getBlock()) + "\n");
        }
        catch (T1UnknownBlockException e) {
            info.append("blocktype= UNKNOWN");
        }
        info.append("\n");
        return info.toString();
    }

    public int getSourceAddress() {
        return this.getNAD() & 0xF;
    }

    public int getDestinationAddress() {
        return this.getNAD() >> 4 & 0xF;
    }

    public int getRequestedSequenceNumber() throws T1Exception {
        return this.getControlBits() >> 4;
    }
}

