/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal;

import opencard.core.terminal.CommandAPDU;

public class ISOCommandAPDU
extends CommandAPDU {
    protected int lc;
    protected int le;
    public static final int CASE_1 = 2;
    public static final int CASE_2S = 8;
    public static final int CASE_2E = 12;
    public static final int CASE_3S = 32;
    public static final int CASE_3E = 48;
    public static final int CASE_4S = 128;
    public static final int CASE_4E = 192;
    public static final int CLASS = 0;
    public static final int INSTRUCTION = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;

    public ISOCommandAPDU(byte classByte, byte instruction, byte p1, byte p2) {
        this(4, classByte, instruction, p1, p2, null, -1);
    }

    public ISOCommandAPDU(int size, byte classByte, byte instruction, byte p1, byte p2) {
        this(size, classByte, instruction, p1, p2, null, -1);
    }

    public ISOCommandAPDU(byte classByte, byte instruction, byte p1, byte p2, int le) {
        this(6, classByte, instruction, p1, p2, null, le);
    }

    public ISOCommandAPDU(int size, byte classByte, byte instruction, byte p1, byte p2, int le) {
        this(size, classByte, instruction, p1, p2, null, le);
    }

    public ISOCommandAPDU(byte classByte, byte instruction, byte p1, byte p2, byte[] data) {
        this(data.length + 5 + 4, classByte, instruction, p1, p2, data, -1);
    }

    public ISOCommandAPDU(int size, byte classByte, byte instruction, byte p1, byte p2, byte[] data) {
        this(size, classByte, instruction, p1, p2, data, -1);
    }

    public ISOCommandAPDU(byte classByte, byte instruction, byte p1, byte p2, byte[] data, int le) {
        this(data.length + 5 + 4, classByte, instruction, p1, p2, data, le);
    }

    public ISOCommandAPDU(int size, byte classByte, byte instruction, byte p1, byte p2, byte[] data, int le) {
        super(size);
        this.le = le;
        this.lc = data == null ? 0 : data.length;
        byte[] body = this.encode(data);
        int L = body == null ? 0 : body.length;
        this.apdu_buffer[0] = classByte;
        this.apdu_buffer[1] = instruction;
        this.apdu_buffer[2] = p1;
        this.apdu_buffer[3] = p2;
        if (body != null) {
            System.arraycopy(body, 0, this.apdu_buffer, 4, L);
        }
        this.apdu_length = 4 + L;
    }

    public byte getCLA() {
        return this.apdu_buffer[0];
    }

    public byte getINS() {
        return this.apdu_buffer[1];
    }

    public byte getP1() {
        return this.apdu_buffer[2];
    }

    public byte getP2() {
        return this.apdu_buffer[3];
    }

    public int getLC() {
        return this.lc;
    }

    public int getLE() {
        return this.le;
    }

    public int getIsoCase() {
        boolean shortCase;
        boolean bl = shortCase = this.lc < 256 && this.le < 256;
        if (this.lc <= 0) {
            if (this.le < 0) {
                return 2;
            }
            return shortCase ? 8 : 12;
        }
        if (this.le < 0) {
            return shortCase ? 32 : 48;
        }
        return shortCase ? 128 : 192;
    }

    @Override
    public void append(byte[] bytes) throws IndexOutOfBoundsException {
        if (this.le != -1) {
            throw new IndexOutOfBoundsException("An le value exists in APDU buffer, therefore no append is possible");
        }
        super.append(bytes);
        this.lc += bytes.length;
    }

    @Override
    public void append(byte b) throws IndexOutOfBoundsException {
        if (this.le != -1) {
            throw new IndexOutOfBoundsException("An le value exists in APDU buffer, therefore no append is possible");
        }
        super.append(b);
        ++this.lc;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer("APDU_Buffer = ");
        ret.append(this.makeHex(this.getBytes()));
        ret.append(" (hex) | lc = ");
        ret.append(this.lc);
        ret.append(" | le = ");
        ret.append(this.le);
        return ret.toString();
    }

    private byte[] encode(byte[] data) {
        int lc = data == null ? 0 : data.length;
        int L = 0;
        boolean useShort = lc < 256 && this.le < 256;
        L += lc;
        if (lc > 0) {
            int n = L = useShort ? L + 1 : L + 3;
        }
        if (this.le >= 0) {
            int n = L = useShort ? L + 1 : L + 2;
        }
        if (L == 0) {
            return null;
        }
        byte[] body = new byte[L];
        int l = 0;
        if (lc > 0) {
            if (useShort) {
                body[l++] = (byte)(lc & 0xFF);
            } else {
                body[l] = 0;
                body[l + 1] = (byte)(lc >> 8 & 0xFF);
                body[l + 2] = (byte)(lc & 0xFF);
                l += 3;
            }
            System.arraycopy(data, 0, body, l, lc);
            l += lc;
        }
        if (this.le >= 0) {
            if (useShort) {
                body[l++] = (byte)(this.le & 0xFF);
            } else {
                body[l] = (byte)(this.le >> 8 & 0xFF);
                body[l + 1] = (byte)(this.le & 0xFF);
            }
        }
        return body;
    }

    private String makeHex(byte[] buffer) {
        int length = buffer.length;
        String blank = "";
        StringBuffer ret = new StringBuffer(2 * length);
        for (int i = 0; i < 2 * length; ++i) {
            byte current = i % 2 == 1 ? (byte)(buffer[i / 2] & 0xF) : (byte)(buffer[i / 2] >> 4 & 0xF);
            ret.append((char)(current < 10 ? current + 48 : current + 55) + (i % 2 == 1 ? blank : ""));
        }
        return ret.toString();
    }
}

