/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.terminal;

import java.util.Hashtable;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.terminal.Lockable;
import opencard.opt.terminal.TerminalLockedException;

public abstract class AbstractLockableTerminal
extends CardTerminal
implements Lockable {
    private Object lockHandle_ = null;
    private Hashtable slotHandles_ = new Hashtable();

    protected Object getTerminalLockHandle() {
        return this.lockHandle_;
    }

    protected Thread getSlotLockHandle(int slot) {
        return (Thread)this.slotHandles_.get(new Integer(slot));
    }

    protected AbstractLockableTerminal(String name, String type, String address) {
        super(name, type, address);
    }

    @Override
    public final synchronized Object lock() throws CardTerminalException {
        if (this.lockHandle_ != null) {
            throw new TerminalLockedException("terminal already locked", this);
        }
        if (!this.slotHandles_.isEmpty()) {
            throw new TerminalLockedException("terminal has locked slots", this);
        }
        int slots = this.getSlots();
        for (int i = 0; i < slots; ++i) {
            if (this.isSlotChannelAvailable(i)) continue;
            throw new TerminalLockedException("terminal has open SlotChannel(s)", this);
        }
        this.internalLock();
        this.lockHandle_ = new Integer(0);
        return this.lockHandle_;
    }

    @Override
    public synchronized void unlock(Object handle) throws CardTerminalException {
        if (this.lockHandle_ == null) {
            throw new TerminalLockedException("terminal not locked", this);
        }
        if (this.lockHandle_ != handle) {
            throw new TerminalLockedException("caller not lock owner", this);
        }
        this.internalUnlock();
        this.lockHandle_ = null;
    }

    @Override
    public Object lockSlot(int slotNr) throws CardTerminalException {
        if (this.lockHandle_ != null) {
            throw new TerminalLockedException("terminal is locked", this);
        }
        Object slotHandle = this.getSlotLockHandle(slotNr);
        if (slotHandle != null) {
            throw new TerminalLockedException("slot is already locked", this);
        }
        if (this.isSlotChannelAvailable(slotNr)) {
            throw new TerminalLockedException("slot is in use, Slotchannel exists", this);
        }
        this.internalLockSlot(slotNr);
        slotHandle = new Integer(slotNr);
        this.slotHandles_.put(new Integer(slotNr), slotHandle);
        return slotHandle;
    }

    @Override
    public void unlockSlot(int slotNr, Object handle) throws CardTerminalException {
        if (!this.isSlotChannelAvailable(slotNr)) {
            throw new TerminalLockedException("can not unlock slot while SlotChannel is open", this);
        }
        Thread slotHandle = this.getSlotLockHandle(slotNr);
        if (slotHandle != handle) {
            throw new TerminalLockedException("invalid handle", this);
        }
        if (slotHandle != null) {
            this.internalUnlockSlot(slotNr);
            this.slotHandles_.remove(new Integer(slotNr));
        }
    }

    protected abstract void internalLock() throws CardTerminalException;

    protected abstract void internalUnlock() throws CardTerminalException;

    protected abstract void internalLockSlot(int var1) throws CardTerminalException;

    protected abstract void internalUnlockSlot(int var1) throws CardTerminalException;

    @Override
    protected final void internalOpenSlotChannel(int slotID) throws CardTerminalException {
        if (this.lockHandle_ != null) {
            throw new TerminalLockedException("terminal is locked", this);
        }
        Thread slotHandle = this.getSlotLockHandle(slotID);
        if (slotHandle != null) {
            throw new TerminalLockedException("slot is locked", this);
        }
        this.lockableOpenSlotChannel(slotID);
    }

    @Override
    protected final void internalOpenSlotChannel(int slotID, Object lockHandle) throws CardTerminalException {
        if (this.lockHandle_ != null && this.lockHandle_ != lockHandle) {
            throw new TerminalLockedException("terminal locked, invalid handle", this);
        }
        Thread slotHandle = this.getSlotLockHandle(slotID);
        if (slotHandle != null && slotHandle != lockHandle) {
            throw new TerminalLockedException("slot is locked, invalid handle", this);
        }
        this.lockableOpenSlotChannel(slotID);
    }

    protected abstract void lockableOpenSlotChannel(int var1) throws CardTerminalException;
}

