/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.math.BigInteger;
import java.security.PublicKey;

public class RSAPublicKey
implements PublicKey {
    protected int el;
    protected BigInteger e = null;
    protected BigInteger m = null;
    protected int inputLength;
    protected int outputLength;
    protected int keyLength;

    public RSAPublicKey(int eLength, byte[] e, byte[] m, int keyLength) {
        this.el = eLength;
        this.e = new BigInteger(1, e);
        this.m = new BigInteger(1, m);
        this.keyLength = keyLength;
        this.inputLength = m.length;
        this.outputLength = m.length;
    }

    public RSAPublicKey(BigInteger e, BigInteger m) {
        this.e = e;
        this.m = m;
        this.el = (e.bitLength() + 7) / 8;
        this.keyLength = m.bitLength();
        this.inputLength = (this.keyLength + 7) / 8;
        this.outputLength = (this.keyLength + 7) / 8;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public int maxInputLength() {
        return this.inputLength;
    }

    public int maxOutputLength() {
        return this.outputLength;
    }

    public BigInteger modulus() {
        return this.m;
    }

    public BigInteger publicExponent() {
        return this.e;
    }
}

