/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.math.BigInteger;
import java.security.PrivateKey;

public class RSACRTKey
implements PrivateKey {
    protected BigInteger p = null;
    protected BigInteger q = null;
    protected BigInteger qm = null;
    protected BigInteger dp = null;
    protected BigInteger dq = null;
    protected int inputLength;
    protected int outputLength;
    protected int keyLength;

    public RSACRTKey(byte[] p, byte[] q, byte[] qm, byte[] dp, byte[] dq, int inputLength, int outputLength, int keyLength) {
        this.p = new BigInteger(1, p);
        this.q = new BigInteger(1, q);
        this.qm = new BigInteger(1, qm);
        this.dp = new BigInteger(1, dp);
        this.dq = new BigInteger(1, dq);
        this.keyLength = keyLength;
        this.inputLength = inputLength;
        this.outputLength = outputLength;
    }

    public RSACRTKey(BigInteger p, BigInteger q, BigInteger qm, BigInteger dp, BigInteger dq) {
        this.p = p;
        this.q = q;
        this.qm = qm;
        this.dp = dp;
        this.dq = dq;
        this.keyLength = p.multiply(q).bitLength();
        this.inputLength = (this.keyLength + 7) / 8;
        this.outputLength = (this.keyLength + 7) / 8;
    }

    public BigInteger coefficient() {
        return this.qm;
    }

    public BigInteger exponent1() {
        return this.dp;
    }

    public BigInteger exponent2() {
        return this.dq;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public int maxOutputLength() {
        return this.outputLength;
    }

    public BigInteger prime1() {
        return this.p;
    }

    public BigInteger prime2() {
        return this.q;
    }
}

