/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import opencard.core.OpenCardRuntimeException;
import opencard.opt.security.PKACredential;
import opencard.opt.security.SignCredential;

public class DSASignCredential
implements PKACredential,
SignCredential {
    protected DSAPrivateKey privKey = null;
    protected Signature JCAsignature = null;

    public DSASignCredential(DSAPrivateKey privateKey) {
        this.privKey = privateKey;
    }

    @Override
    public byte[] sign(byte[] data) throws OpenCardRuntimeException {
        if (data.length != this.getInputLength()) {
            throw new OpenCardRuntimeException("DSASignCredential: invalid input block length");
        }
        try {
            if (this.JCAsignature == null) {
                this.JCAsignature = Signature.getInstance("SHA1withDSA", "BC");
                this.JCAsignature.initSign(this.privKey);
            }
            this.JCAsignature.update(data);
            return this.JCAsignature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new OpenCardRuntimeException("DSASignCredential: no JCA provider for DSA available");
        }
        catch (InvalidKeyException e) {
            throw new OpenCardRuntimeException("DSASignCredential: key rejected by JCA DSA provider");
        }
        catch (SignatureException e) {
            throw new OpenCardRuntimeException("DSASignCredential: SignatureException: " + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new OpenCardRuntimeException("DSASignCredential: no JCA provider 'Bouncy Castle' available");
        }
    }

    @Override
    public int getInputLength() {
        return this.privKey.getParams().getP().bitLength() / 8;
    }
}

