/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.ms;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import opencard.core.util.SystemAccess;

public class MicrosoftSystemAccess
extends SystemAccess {
    public MicrosoftSystemAccess() {
        PolicyEngine.assertPermission(PermissionID.SYSTEM);
    }

    @Override
    public boolean getBoolean(String key) {
        PolicyEngine.assertPermission(PermissionID.PROPERTY);
        return Boolean.getBoolean(key);
    }

    @Override
    public Properties getProperties() {
        PolicyEngine.assertPermission(PermissionID.PROPERTY);
        return System.getProperties();
    }

    @Override
    public String getProperty(String key) {
        PolicyEngine.assertPermission(PermissionID.PROPERTY);
        return System.getProperty(key);
    }

    @Override
    public String getProperty(String key, String def) {
        PolicyEngine.assertPermission(PermissionID.PROPERTY);
        return System.getProperty(key, def);
    }

    @Override
    public void loadLibrary(String libName) {
        PolicyEngine.assertPermission(PermissionID.SYSTEM);
        System.loadLibrary(libName);
    }

    @Override
    public Properties loadProperties(String filename) throws FileNotFoundException, IOException {
        PolicyEngine.assertPermission(PermissionID.FILEIO);
        Properties props = new Properties();
        props.load(new FileInputStream(new File(filename)));
        return props;
    }
}

