/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.EOFException;
import java.io.IOException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.CardRandomAccess;
import opencard.opt.iso.fs.CardRecord;

public class CardRandomRecordAccess
extends CardRandomAccess {
    public CardRandomRecordAccess(CardFile scFile) throws CardTerminalException, IOException {
        this(scFile, "rw");
    }

    public CardRandomRecordAccess(CardFile scFile, String accessMode) throws CardTerminalException, IOException {
        super(scFile, accessMode);
        if (this.file.isDirectory() || this.file.isTransparent()) {
            throw new CardIOException("not a structured file " + this.file.getPath());
        }
        if (this.file.isCyclic()) {
            throw new CardIOException("cyclic file: " + this.file.getPath());
        }
    }

    public long getFilePointer() throws IOException, CardTerminalException {
        return this.filePointer;
    }

    public void seek(long pos) throws EOFException, CardTerminalException {
        int size;
        int length;
        int records;
        if (!this.file.isVariable() && pos >= (long)(records = (length = this.file.getLength()) / (size = this.file.getRecordSize()))) {
            throw new EOFException("seek past end of file");
        }
        this.filePointer = (int)pos;
    }

    public int skip(int n) throws EOFException, CardTerminalException {
        this.seek(this.filePointer + n);
        return n;
    }

    public CardRecord readRecord() throws IOException, CardTerminalException {
        CardRecord cr = null;
        byte[] data = this.fileSystem.readRecord(this.file.getPath(), this.filePointer);
        if (data != null) {
            cr = new CardRecord(data);
            ++this.filePointer;
        }
        return cr;
    }

    public int read(CardRecord[] r) throws IOException, CardTerminalException {
        return this.read(r, 0, r.length);
    }

    public int read(CardRecord[] r, int off, int len) throws IOException, CardTerminalException {
        int i = 0;
        while (len > 0) {
            r[off] = this.readRecord();
            if (r[off] == null) break;
            --len;
            ++i;
            ++off;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public void write(CardRecord r) throws IOException, CardTerminalException {
        this.fileSystem.writeRecord(this.file.getPath(), this.filePointer, r.bytes());
        ++this.filePointer;
    }

    public void write(CardRecord[] r) throws IOException, CardTerminalException {
        this.write(r, 0, r.length);
    }

    public void write(CardRecord[] r, int off, int len) throws IOException, CardTerminalException {
        while (len > 0) {
            this.write(r[off]);
            ++off;
            --len;
        }
    }
}

