/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.CardRandomAccess;

public class CardRandomByteAccess
extends CardRandomAccess
implements DataOutput,
DataInput {
    public CardRandomByteAccess(CardFile scFile) throws CardTerminalException, IOException {
        this(scFile, "rw");
    }

    public CardRandomByteAccess(CardFile scFile, String accessMode) throws CardTerminalException, IOException {
        super(scFile, accessMode);
        if (!this.file.isTransparent()) {
            throw new CardIOException("not transparent: " + this.file.getPath());
        }
    }

    public int read() throws IOException, CardTerminalException {
        byte[] data = this.fileSystem.read(this.file.getPath(), this.filePointer, 1);
        ++this.filePointer;
        return data == null ? -1 : data[0];
    }

    public int read(byte[] b) throws IOException, CardTerminalException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException, CardTerminalException {
        byte[] data = this.fileSystem.read(this.file.getPath(), this.filePointer, len);
        if (data == null) {
            return -1;
        }
        System.arraycopy(data, 0, b, off, data.length);
        this.filePointer += data.length;
        return data.length;
    }

    @Override
    public boolean readBoolean() throws IOException, CardTerminalException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException, CardTerminalException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException, CardTerminalException {
        byte[] bytes = new byte[2];
        int expectingTwo = this.read(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes, 0, expectingTwo));
        return in.readChar();
    }

    @Override
    public double readDouble() throws IOException, CardTerminalException {
        byte[] bytes = new byte[8];
        int expectingEight = this.read(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes, 0, expectingEight));
        return in.readDouble();
    }

    @Override
    public float readFloat() throws IOException, CardTerminalException {
        byte[] bytes = new byte[4];
        int expectingFour = this.read(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes, 0, expectingFour));
        return in.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException, CardTerminalException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException, CardTerminalException {
        int readCount = 0;
        for (int i = 0; i < len; i += readCount) {
            readCount = this.read(b, off + i, len - i);
            if (readCount >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws IOException, CardTerminalException {
        byte[] bytes = new byte[4];
        this.readFully(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        return in.readInt();
    }

    @Override
    public String readLine() throws IOException, CardTerminalException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.read()) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public long readLong() throws IOException, CardTerminalException {
        byte[] bytes = new byte[8];
        this.readFully(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        return in.readLong();
    }

    @Override
    public short readShort() throws IOException, CardTerminalException {
        byte[] bytes = new byte[2];
        this.readFully(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        return in.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException, CardTerminalException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public int readUnsignedShort() throws IOException, CardTerminalException {
        byte[] bytes = new byte[2];
        this.readFully(bytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        return in.readUnsignedShort();
    }

    @Override
    public int skipBytes(int n) throws IOException, CardTerminalException {
        long length = this.file.getLength();
        if ((long)(this.filePointer + n) > length) {
            throw new EOFException("skip");
        }
        this.filePointer += n;
        return n;
    }

    @Override
    public String readUTF() throws IOException, CardTerminalException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public void write(int b) throws IOException, CardTerminalException {
        byte[] data = new byte[]{(byte)b};
        this.fileSystem.write(this.file.getPath(), this.filePointer, data);
        ++this.filePointer;
    }

    @Override
    public void write(byte[] b) throws IOException, CardTerminalException {
        this.fileSystem.write(this.file.getPath(), this.filePointer, b);
        this.filePointer += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException, CardTerminalException {
        byte[] data = new byte[len];
        System.arraycopy(b, off, data, 0, len);
        this.write(data);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException, CardTerminalException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException, CardTerminalException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeBytes(s);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeChar(int v) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeChar(v);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeChars(String s) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeChars(s);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeDouble(double v) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeDouble(v);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeFloat(float v) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeFloat(v);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeInt(int v) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(v);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeLong(long v) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeLong(v);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeShort(int v) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeShort(v);
        this.write(baos.toByteArray());
    }

    @Override
    public void writeUTF(String str) throws IOException, CardTerminalException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        DataOutputStream out = new DataOutputStream(baos);
        out.writeUTF(str);
        this.write(baos.toByteArray());
    }
}

