/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import opencard.core.util.HexString;
import opencard.opt.iso.fs.CardFilePathComponent;

public class CardFileShortFileID
extends CardFilePathComponent {
    public CardFileShortFileID(String comp) {
        super(comp);
        if (!comp.startsWith(":")) {
            throw new IllegalArgumentException("short file ID must start with /");
        }
        if (comp.length() != 3) {
            throw new IllegalArgumentException("short file ID component " + comp + " must be a single byte");
        }
    }

    public CardFileShortFileID(byte bite) {
        this.comp = ":" + HexString.hexify(bite & 0xFF);
    }

    public byte toByte() {
        return (byte)(Integer.parseInt(this.comp.substring(1), 16) & 0xFF);
    }

    @Override
    public boolean equals(Object comp) {
        if (!(comp instanceof CardFileShortFileID)) {
            return false;
        }
        return this.toByte() == ((CardFileShortFileID)comp).toByte();
    }

    @Override
    public int hashCode() {
        return -97170432 + this.toByte();
    }
}

