/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.io.IOException;
import java.io.OutputStream;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileAccessCardService;

public class CardFileOutputStream
extends OutputStream {
    private FileAccessCardService fileSystem = null;
    private CardFile cf = null;
    private int filePointer = 0;
    private boolean open;

    public CardFileOutputStream(CardFile file) throws IOException, CardIOException, CardTerminalException {
        this.cf = file;
        this.fileSystem = file.getFileAccessService();
        if (!this.cf.isTransparent()) {
            throw new CardIOException("not transparent: " + file.getPath());
        }
        this.filePointer = 0;
        this.open = true;
    }

    @Override
    public void close() throws IOException, CardTerminalException {
        if (this.open) {
            this.open = false;
        }
        this.fileSystem = null;
        this.cf = null;
    }

    @Override
    public void flush() throws IOException, CardTerminalException {
    }

    @Override
    public void write(int b) throws IOException, CardTerminalException {
        byte[] data = new byte[]{(byte)b};
        this.fileSystem.write(this.cf.getPath(), this.filePointer, data);
        ++this.filePointer;
    }

    @Override
    public void write(byte[] b) throws IOException, CardTerminalException {
        this.fileSystem.write(this.cf.getPath(), this.filePointer, b);
        this.filePointer += b.length;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException, CardTerminalException {
        byte[] data = new byte[length];
        System.arraycopy(b, offset, data, 0, length);
        this.write(data);
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

